/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import java.util.concurrent.ExecutorService;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.reflect.DirectInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileWatcherFactory
implements FileWatcherFactory,
Stoppable {
    private final ExecutorService executor;
    private final JavaVersion javaVersion;
    private final ClassLoader classLoader;
    private FileWatcherFactory fileWatcherFactory;

    public DefaultFileWatcherFactory(ExecutorFactory executorFactory) {
        this(JavaVersion.current(), DefaultFileWatcherFactory.class.getClassLoader(), executorFactory);
    }

    DefaultFileWatcherFactory(JavaVersion javaVersion, ClassLoader classLoader, ExecutorFactory executorFactory) {
        this.javaVersion = javaVersion;
        this.classLoader = classLoader;
        this.executor = executorFactory.create("filewatcher");
    }

    protected FileWatcherFactory createFileWatcherFactory() {
        if (this.javaVersion.isJava7Compatible()) {
            try {
                Class<?> clazz = this.classLoader.loadClass("org.gradle.internal.filewatch.jdk7.Jdk7FileWatcherFactory");
                return (FileWatcherFactory)Cast.uncheckedCast((Object)DirectInstantiator.instantiate(clazz, (Object[])new Object[]{this.executor}));
            }
            catch (ClassNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        throw new UnsupportedOperationException("File watching requires Java 7 or later.");
    }

    public void stop() {
        this.executor.shutdown();
    }

    @Override
    public FileWatcher watch(FileSystemSubset systemSubset, Action<? super Throwable> onError, FileWatcherListener listener) {
        if (this.fileWatcherFactory == null) {
            this.fileWatcherFactory = this.createFileWatcherFactory();
        }
        return this.fileWatcherFactory.watch(systemSubset, onError, listener);
    }
}

