/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.CmdVersionClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class SvnExecutableChecker
extends ExecutableValidator {
    private static final Logger LOG = Logger.getInstance(SvnExecutableChecker.class);
    public static final String SVN_EXECUTABLE_LOCALE_REGISTRY_KEY = "svn.executable.locale";
    private static final String SVN_VERSION_ENGLISH_OUTPUT = "The following repository access (RA) modules are available";
    private static final Pattern INVALID_LOCALE_WARNING_PATTERN = Pattern.compile("^.*cannot set .* locale.*please check that your locale name is correct$", 42);
    @NotNull
    private final SvnVcs myVcs;

    public SvnExecutableChecker(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "<init>"));
        }
        super(vcs.getProject(), SvnExecutableChecker.getNotificationTitle(), SvnExecutableChecker.getWrongPathMessage());
        this.myVcs = vcs;
        Registry.get((String)SVN_EXECUTABLE_LOCALE_REGISTRY_KEY).addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker$1", "afterValueChanged"));
                }
                SvnExecutableChecker.this.myVcs.checkCommandLineVersion();
            }
        }, (Disposable)this.myProject);
    }

    protected String getCurrentExecutable() {
        return SvnApplicationSettings.getInstance().getCommandLinePath();
    }

    @NotNull
    protected String getConfigurableDisplayName() {
        if ("Subversion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "getConfigurableDisplayName"));
        }
        return "Subversion";
    }

    protected boolean notify(@Nullable Notification notification) {
        this.expireAll();
        return super.notify(notification);
    }

    public void expireAll() {
        for (ExecutableValidator.ExecutableNotValidNotification notification : (ExecutableValidator.ExecutableNotValidNotification[])this.myNotificationManager.getNotificationsOfType(ExecutableValidator.ExecutableNotValidNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    protected void showSettingsAndExpireIfFixed(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "showSettingsAndExpireIfFixed"));
        }
        this.showSettings();
        notification.expire();
        this.myVcs.checkCommandLineVersion();
    }

    @Nullable
    protected Notification validate(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "validate"));
        }
        ExecutableValidator.ExecutableNotValidNotification result = this.createDefaultNotification();
        Version version = this.getConfiguredClientVersion();
        if (version != null) {
            try {
                result = this.validateVersion(version);
                if (result == null) {
                    result = this.validateLocale();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return result;
    }

    @Nullable
    private Notification validateVersion(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "validateVersion"));
        }
        return !this.myVcs.isSupportedByCommandLine(WorkingCopyFormat.from(version)) ? new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, SvnExecutableChecker.getOldExecutableMessage(version)) : null;
    }

    @Nullable
    private Notification validateLocale() throws SvnBindException {
        ProcessOutput versionOutput = this.getVersionClient().runCommand(false);
        ExecutableValidator.ExecutableNotValidNotification result = null;
        Matcher matcher = INVALID_LOCALE_WARNING_PATTERN.matcher(versionOutput.getStderr());
        if (matcher.find()) {
            LOG.info(matcher.group());
            result = new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, this.prepareDescription(UIUtil.getHtmlBody((String)matcher.group()), false), NotificationType.WARNING);
        } else if (!SvnExecutableChecker.isEnglishOutput(versionOutput.getStdout())) {
            LOG.info("\"svn --version\" command contains non-English output " + versionOutput.getStdout());
            result = new ExecutableValidator.ExecutableNotValidNotification((ExecutableValidator)this, this.prepareDescription(SvnBundle.message("non.english.locale.detected.warning", new Object[0]), false), NotificationType.WARNING);
        }
        return result;
    }

    @Nullable
    private Version getConfiguredClientVersion() {
        Version result = null;
        try {
            result = this.getVersionClient().getVersion();
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        return result;
    }

    @NotNull
    private CmdVersionClient getVersionClient() {
        CmdVersionClient cmdVersionClient = (CmdVersionClient)this.myVcs.getCommandLineFactory().createVersionClient();
        if (cmdVersionClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "getVersionClient"));
        }
        return cmdVersionClient;
    }

    public static boolean isEnglishOutput(@NotNull String versionOutput) {
        if (versionOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionOutput", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "isEnglishOutput"));
        }
        return StringUtil.containsIgnoreCase((String)versionOutput, (String)SVN_VERSION_ENGLISH_OUTPUT);
    }

    private static String getWrongPathMessage() {
        return SvnBundle.message("subversion.executable.notification.description", new Object[0]);
    }

    private static String getNotificationTitle() {
        return SvnBundle.message("subversion.executable.notification.title", new Object[0]);
    }

    private static String getOldExecutableMessage(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/idea/svn/commandLine/SvnExecutableChecker", "getOldExecutableMessage"));
        }
        return SvnBundle.message("subversion.executable.too.old", version);
    }
}

