/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoCached {
    @NotNull
    private final Map<Long, SvnMergeInfoCache.MergeCheckResult> myMap;
    private final long myCopyRevision;

    public MergeInfoCached() {
        this.myMap = ContainerUtil.newHashMap();
        this.myCopyRevision = -1L;
    }

    public MergeInfoCached(@NotNull Map<Long, SvnMergeInfoCache.MergeCheckResult> map, long copyRevision) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/idea/svn/mergeinfo/MergeInfoCached", "<init>"));
        }
        this.myMap = ContainerUtil.newHashMap(map);
        this.myCopyRevision = copyRevision;
    }

    @NotNull
    public Map<Long, SvnMergeInfoCache.MergeCheckResult> getMap() {
        Map<Long, SvnMergeInfoCache.MergeCheckResult> map = this.myMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/MergeInfoCached", "getMap"));
        }
        return map;
    }

    @NotNull
    public MergeInfoCached copy() {
        MergeInfoCached mergeInfoCached = new MergeInfoCached(this.myMap, this.myCopyRevision);
        if (mergeInfoCached == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/MergeInfoCached", "copy"));
        }
        return mergeInfoCached;
    }

    public boolean copiedAfter(@NotNull CommittedChangeList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/mergeinfo/MergeInfoCached", "copiedAfter"));
        }
        return this.myCopyRevision != -1L && this.myCopyRevision >= list.getNumber();
    }
}

