/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnHttpAuthMethodsDefaultChecker;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.svnkit.SvnKitAdminAreaFactorySelector;
import org.jetbrains.idea.svn.svnkit.SvnKitDebugLogger;
import org.jetbrains.idea.svn.svnkit.lowLevel.PrimitivePool;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SvnKitManager {
    private static final Logger LOG = SvnVcs.wrapLogger(Logger.getInstance(SvnKitManager.class));
    @NonNls
    public static final String LOG_PARAMETER_NAME = "javasvn.log";
    @NonNls
    public static final String TRACE_NATIVE_CALLS = "javasvn.log.native";
    @NonNls
    public static final String SVNKIT_HTTP_SSL_PROTOCOLS = "svnkit.http.sslProtocols";
    @Nullable
    private static String ourExplicitlySetSslProtocols;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    @NotNull
    private final SvnConfiguration myConfiguration;

    public SvnKitManager(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "<init>"));
        }
        this.myVcs = vcs;
        this.myProject = this.myVcs.getProject();
        this.myConfiguration = this.myVcs.getSvnConfiguration();
        this.refreshSSLProperty();
    }

    @Nullable
    public static String getExplicitlySetSslProtocols() {
        return ourExplicitlySetSslProtocols;
    }

    public static boolean isSSLProtocolExplicitlySet() {
        return ourExplicitlySetSslProtocols != null;
    }

    public void refreshSSLProperty() {
        if (SvnKitManager.isSSLProtocolExplicitlySet()) {
            return;
        }
        if (SvnConfiguration.SSLProtocols.all.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.clearProperty(SVNKIT_HTTP_SSL_PROTOCOLS);
        } else if (SvnConfiguration.SSLProtocols.sslv3.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.setProperty(SVNKIT_HTTP_SSL_PROTOCOLS, "SSLv3");
        } else if (SvnConfiguration.SSLProtocols.tlsv1.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.setProperty(SVNKIT_HTTP_SSL_PROTOCOLS, "TLSv1");
        }
    }

    public void activate() {
        if (SystemInfo.isWindows) {
            if (!SVNJNAUtil.isJNAPresent()) {
                Notifications.Bus.notify((Notification)new Notification(this.myVcs.getDisplayName(), "Subversion plugin: no JNA", "A problem with JNA initialization for SVNKit library. Encryption is not available.", NotificationType.WARNING), (Project)this.myProject);
            } else if (!SVNJNAUtil.isWinCryptEnabled()) {
                Notifications.Bus.notify((Notification)new Notification(this.myVcs.getDisplayName(), "Subversion plugin: no encryption", "A problem with encryption module (Crypt32.dll) initialization for SVNKit library. Encryption is not available.", NotificationType.WARNING), (Project)this.myProject);
            }
        }
    }

    @NotNull
    public ISVNOptions getSvnOptions() {
        ISVNOptions iSVNOptions = this.myConfiguration.getOptions();
        if (iSVNOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "getSvnOptions"));
        }
        return iSVNOptions;
    }

    @NotNull
    public SVNRepository createRepository(String url) throws SVNException {
        SVNRepository sVNRepository = this.createRepository(SVNURL.parseURIEncoded((String)url));
        if (sVNRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createRepository"));
        }
        return sVNRepository;
    }

    @NotNull
    public SVNRepository createRepository(@NotNull SVNURL url) throws SVNException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createRepository"));
        }
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)url);
        repository.setAuthenticationManager((ISVNAuthenticationManager)this.getAuthenticationManager());
        repository.setTunnelProvider((ISVNTunnelProvider)this.getSvnOptions());
        SVNRepository sVNRepository = repository;
        if (sVNRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createRepository"));
        }
        return sVNRepository;
    }

    @NotNull
    private ISVNRepositoryPool getPool() {
        ISVNRepositoryPool iSVNRepositoryPool = this.getPool((ISVNAuthenticationManager)this.getAuthenticationManager());
        if (iSVNRepositoryPool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "getPool"));
        }
        return iSVNRepositoryPool;
    }

    @NotNull
    private ISVNRepositoryPool getPool(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "getPool"));
        }
        if (this.myProject.isDisposed()) {
            throw new ProcessCanceledException();
        }
        PrimitivePool primitivePool = new PrimitivePool(manager, (ISVNTunnelProvider)this.getSvnOptions());
        if (primitivePool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "getPool"));
        }
        return primitivePool;
    }

    @NotNull
    public SVNUpdateClient createUpdateClient() {
        SVNUpdateClient sVNUpdateClient = this.setupClient(new SVNUpdateClient(this.getPool(), this.getSvnOptions()));
        if (sVNUpdateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createUpdateClient"));
        }
        return sVNUpdateClient;
    }

    @NotNull
    public SVNUpdateClient createUpdateClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createUpdateClient"));
        }
        SVNUpdateClient sVNUpdateClient = SvnKitManager.setupClient(new SVNUpdateClient(this.getPool(manager), this.getSvnOptions()), manager);
        if (sVNUpdateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createUpdateClient"));
        }
        return sVNUpdateClient;
    }

    @NotNull
    public SVNStatusClient createStatusClient() {
        SVNStatusClient client = new SVNStatusClient(this.getPool(), this.getSvnOptions());
        client.setIgnoreExternals(false);
        SVNStatusClient sVNStatusClient = this.setupClient(client);
        if (sVNStatusClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createStatusClient"));
        }
        return sVNStatusClient;
    }

    @NotNull
    public SVNWCClient createWCClient() {
        SVNWCClient sVNWCClient = this.setupClient(new SVNWCClient(this.getPool(), this.getSvnOptions()));
        if (sVNWCClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createWCClient"));
        }
        return sVNWCClient;
    }

    @NotNull
    public SVNWCClient createUpgradeClient() {
        SVNWCClient sVNWCClient = new SVNWCClient(this.createOperationFactory());
        if (sVNWCClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createUpgradeClient"));
        }
        return sVNWCClient;
    }

    @NotNull
    public SVNWCClient createWCClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createWCClient"));
        }
        SVNWCClient sVNWCClient = SvnKitManager.setupClient(new SVNWCClient(this.getPool(manager), this.getSvnOptions()), manager);
        if (sVNWCClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createWCClient"));
        }
        return sVNWCClient;
    }

    @NotNull
    public SVNCopyClient createCopyClient() {
        SVNCopyClient sVNCopyClient = this.setupClient(new SVNCopyClient(this.getPool(), this.getSvnOptions()));
        if (sVNCopyClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createCopyClient"));
        }
        return sVNCopyClient;
    }

    @NotNull
    public SVNMoveClient createMoveClient() {
        SVNMoveClient sVNMoveClient = this.setupClient(new SVNMoveClient(this.getPool(), this.getSvnOptions()));
        if (sVNMoveClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createMoveClient"));
        }
        return sVNMoveClient;
    }

    @NotNull
    public SVNLogClient createLogClient() {
        SVNLogClient sVNLogClient = this.setupClient(new SVNLogClient(this.getPool(), this.getSvnOptions()));
        if (sVNLogClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createLogClient"));
        }
        return sVNLogClient;
    }

    @NotNull
    public SVNLogClient createLogClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createLogClient"));
        }
        SVNLogClient sVNLogClient = SvnKitManager.setupClient(new SVNLogClient(this.getPool(manager), this.getSvnOptions()), manager);
        if (sVNLogClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createLogClient"));
        }
        return sVNLogClient;
    }

    @NotNull
    public SVNCommitClient createCommitClient() {
        SVNCommitClient sVNCommitClient = this.setupClient(new SVNCommitClient(this.getPool(), this.getSvnOptions()));
        if (sVNCommitClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createCommitClient"));
        }
        return sVNCommitClient;
    }

    @NotNull
    public SVNDiffClient createDiffClient() {
        SVNDiffClient sVNDiffClient = this.setupClient(new SVNDiffClient(this.getPool(), this.getSvnOptions()));
        if (sVNDiffClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createDiffClient"));
        }
        return sVNDiffClient;
    }

    @NotNull
    public SVNChangelistClient createChangelistClient() {
        SVNChangelistClient sVNChangelistClient = this.setupClient(new SVNChangelistClient(this.getPool(), this.getSvnOptions()));
        if (sVNChangelistClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createChangelistClient"));
        }
        return sVNChangelistClient;
    }

    @NotNull
    public SvnOperationFactory createOperationFactory() {
        OperationFactory result = new OperationFactory();
        result.setOptions(this.getSvnOptions());
        result.setRepositoryPool(this.getPool());
        result.setAuthenticationManager((ISVNAuthenticationManager)this.getAuthenticationManager());
        OperationFactory operationFactory = result;
        if (operationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "createOperationFactory"));
        }
        return operationFactory;
    }

    @NotNull
    private SvnAuthenticationManager getAuthenticationManager() {
        SvnAuthenticationManager svnAuthenticationManager = this.myConfiguration.getAuthenticationManager(this.myVcs);
        if (svnAuthenticationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "getAuthenticationManager"));
        }
        return svnAuthenticationManager;
    }

    @NotNull
    private <T extends SVNBasicClient> T setupClient(@NotNull T client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "setupClient"));
        }
        T t = SvnKitManager.setupClient(client, (ISVNAuthenticationManager)this.getAuthenticationManager());
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "setupClient"));
        }
        return t;
    }

    @NotNull
    private static <T extends SVNBasicClient> T setupClient(@NotNull T client, @NotNull ISVNAuthenticationManager manager) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "setupClient"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "setupClient"));
        }
        client.getOperationsFactory().setAuthenticationManager(manager);
        T t = client;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager", "setupClient"));
        }
        return t;
    }

    static {
        System.setProperty("svnkit.log.native.calls", "true");
        SvnKitDebugLogger logger = new SvnKitDebugLogger(Boolean.getBoolean(LOG_PARAMETER_NAME), Boolean.getBoolean(TRACE_NATIVE_CALLS), LOG);
        SVNDebugLog.setDefaultLog((ISVNDebugLog)logger);
        SVNJNAUtil.setJNAEnabled((boolean)true);
        SvnHttpAuthMethodsDefaultChecker.check();
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SvnKitAdminAreaFactorySelector());
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (SystemInfo.isWindows) {
            SVNAdminArea14.setOptimizedWritingEnabled((boolean)true);
        }
        if (!SVNJNAUtil.isJNAPresent()) {
            LOG.warn("JNA is not found by svnkit library");
        }
        ourExplicitlySetSslProtocols = System.getProperty(SVNKIT_HTTP_SSL_PROTOCOLS);
    }

    private static class OperationFactory
    extends SvnOperationFactory {
        private OperationFactory() {
        }

        @NotNull
        public SvnUpgrade createUpgrade() {
            SvnUpgrade result = super.createUpgrade();
            result.setTargetWorkingCopyFormat(29);
            SvnUpgrade svnUpgrade = result;
            if (svnUpgrade == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager$OperationFactory", "createUpgrade"));
            }
            return svnUpgrade;
        }
    }
}

