/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import git4idea.GitFormatException;
import git4idea.GitVcs;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitChangeType;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogStatusInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogParser {
    public static final String RECORD_START = "\u0001";
    public static final String ITEMS_SEPARATOR = "\u0002";
    public static final String RECORD_END = "\u0003";
    public static final String RECORD_START_GIT = "%x01";
    private static final String ITEMS_SEPARATOR_GIT = "%x02";
    private static final String RECORD_END_GIT = "%x03";
    private final String myFormat;
    private final GitLogOption[] myOptions;
    private final boolean mySupportsRawBody;
    private final NameStatus myNameStatusOption;
    private static final Pattern ONE_RECORD = Pattern.compile("\u0001?(.*)\u0003\n*(.*)", 32);
    private static final String SINGLE_PATH = "([^\t\r\n]+)";
    private static final String EOL = "\\s*(?:\r|\n|\r\n)";
    private static final String PATHS = "([^\t\r\n]+)(?:\t([^\t\r\n]+))?(?:\\s*(?:\r|\n|\r\n))?";
    private static Pattern NAME_ONLY = Pattern.compile("([^\t\r\n]+)(?:\t([^\t\r\n]+))?(?:\\s*(?:\r|\n|\r\n))?");
    private static Pattern NAME_STATUS = Pattern.compile("([\\S]+)\t([^\t\r\n]+)(?:\t([^\t\r\n]+))?(?:\\s*(?:\r|\n|\r\n))?");

    GitLogParser(Project project, GitLogOption ... options) {
        this(project, NameStatus.NONE, options);
    }

    GitLogParser(Project project, NameStatus nameStatusOption, GitLogOption ... options) {
        this.myFormat = GitLogParser.makeFormatFromOptions(options);
        this.myOptions = options;
        this.myNameStatusOption = nameStatusOption;
        GitVcs vcs = GitVcs.getInstance(project);
        this.mySupportsRawBody = vcs != null && GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(vcs.getVersion());
    }

    private static String makeFormatFromOptions(GitLogOption[] options) {
        Function<GitLogOption, String> function = new Function<GitLogOption, String>(){

            public String fun(GitLogOption option) {
                return "%" + option.getPlaceholder();
            }
        };
        return RECORD_START_GIT + StringUtil.join((Object[])options, (Function)function, (String)ITEMS_SEPARATOR_GIT) + RECORD_END_GIT;
    }

    String getPretty() {
        return "--pretty=format:" + this.myFormat;
    }

    @NotNull
    List<GitLogRecord> parse(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/history/GitLogParser", "parse"));
        }
        List records = StringUtil.split((String)output, (String)RECORD_START);
        String notMatchedPart = null;
        ArrayList<GitLogRecord> res = new ArrayList<GitLogRecord>(records.size());
        for (String record : records) {
            if (record.trim().isEmpty()) continue;
            if (notMatchedPart != null) {
                record = notMatchedPart + record;
            }
            if (ONE_RECORD.matcher(record).matches()) {
                notMatchedPart = null;
                res.add(this.parseOneRecord(record));
                continue;
            }
            notMatchedPart = record;
        }
        ArrayList<GitLogRecord> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogParser", "parse"));
        }
        return arrayList;
    }

    @Nullable
    GitLogRecord parseOneRecord(@NotNull String line) {
        ArrayList<GitLogStatusInfo> statuses;
        ArrayList<String> paths;
        Map<GitLogOption, String> res;
        block10: {
            String commitInfo;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "git4idea/history/GitLogParser", "parseOneRecord"));
            }
            if (line.isEmpty()) {
                return null;
            }
            Matcher matcher = ONE_RECORD.matcher(line);
            if (!matcher.matches()) {
                GitLogParser.throwGFE("ONE_RECORD didn't match", line);
            }
            if ((commitInfo = matcher.group(1)) == null) {
                GitLogParser.throwGFE("No match for group#1 in", line);
            }
            res = this.parseCommitInfo(commitInfo);
            paths = new ArrayList<String>(1);
            statuses = new ArrayList<GitLogStatusInfo>();
            if (this.myNameStatusOption == NameStatus.NONE) break block10;
            String pathsAndStatuses = matcher.group(2);
            if (pathsAndStatuses == null) {
                GitLogParser.throwGFE("No match for group#2 in", line);
            }
            if (this.myNameStatusOption == NameStatus.NAME) {
                Matcher pathsMatcher = NAME_ONLY.matcher(pathsAndStatuses);
                while (pathsMatcher.find()) {
                    String path1 = pathsMatcher.group(1);
                    String path2 = pathsMatcher.group(2);
                    GitLogParser.assertNotNull(path1, "path", pathsAndStatuses);
                    paths.add(path1);
                    if (path2 == null) continue;
                    paths.add(path2);
                }
            } else {
                Matcher nameStatusMatcher = NAME_STATUS.matcher(pathsAndStatuses);
                while (nameStatusMatcher.find()) {
                    String status = nameStatusMatcher.group(1);
                    String path1 = nameStatusMatcher.group(2);
                    String path2 = nameStatusMatcher.group(3);
                    GitLogParser.assertNotNull(status, "status", pathsAndStatuses);
                    GitLogParser.assertNotNull(path1, "path1", pathsAndStatuses);
                    paths.add(path1);
                    if (path2 != null) {
                        paths.add(path2);
                    }
                    statuses.add(new GitLogStatusInfo(GitChangeType.fromString(status), path1, path2));
                }
            }
        }
        return new GitLogRecord(res, paths, statuses, this.mySupportsRawBody);
    }

    @NotNull
    private Map<GitLogOption, String> parseCommitInfo(@NotNull String commitInfo) {
        int i;
        if (commitInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitInfo", "git4idea/history/GitLogParser", "parseCommitInfo"));
        }
        String[] values = commitInfo.split(ITEMS_SEPARATOR);
        HashMap<GitLogOption, String> res = new HashMap<GitLogOption, String>(values.length);
        for (i = 0; i < values.length && i < this.myOptions.length; ++i) {
            res.put(this.myOptions[i], values[i]);
        }
        while (i < this.myOptions.length) {
            res.put(this.myOptions[i], "");
            ++i;
        }
        HashMap<GitLogOption, String> hashMap = res;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogParser", "parseCommitInfo"));
        }
        return hashMap;
    }

    private static void assertNotNull(String value, String valueName, String line) {
        if (value == null) {
            GitLogParser.throwGFE("Unexpectedly null " + valueName + " in ", line);
        }
    }

    private static void throwGFE(String message, String line) {
        throw new GitFormatException(message + " [" + StringUtil.escapeStringCharacters((String)line) + "]");
    }

    static enum GitLogOption {
        HASH("H"),
        COMMIT_TIME("ct"),
        AUTHOR_NAME("an"),
        AUTHOR_TIME("at"),
        AUTHOR_EMAIL("ae"),
        COMMITTER_NAME("cn"),
        COMMITTER_EMAIL("ce"),
        SUBJECT("s"),
        BODY("b"),
        PARENTS("P"),
        REF_NAMES("d"),
        SHORT_REF_LOG_SELECTOR("gd"),
        RAW_BODY("B");

        private String myPlaceholder;

        private GitLogOption(String placeholder) {
            this.myPlaceholder = placeholder;
        }

        private String getPlaceholder() {
            return this.myPlaceholder;
        }
    }

    static enum NameStatus {
        NONE,
        NAME,
        STATUS;

    }
}

