/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;

public class AntCreateTargetFix
implements LocalQuickFix {
    private static final String TAG_NAME = "target";
    private static final String NAME_ATTR = "name";
    private final String myCanonicalText;

    public AntCreateTargetFix(String canonicalText) {
        this.myCanonicalText = canonicalText;
    }

    @NotNull
    public String getName() {
        String string = AntBundle.message("ant.create.target.intention.description", this.myCanonicalText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/quickfix/AntCreateTargetFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = AntBundle.message("ant.intention.create.target.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/quickfix/AntCreateTargetFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlFile xmlFile;
        XmlTag rootTag;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ant/quickfix/AntCreateTargetFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/ant/quickfix/AntCreateTargetFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile containingFile = psiElement.getContainingFile();
        Navigatable result = null;
        if (containingFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)containingFile).getRootTag()) != null && FileModificationService.getInstance().prepareFileForWrite((PsiFile)xmlFile)) {
            Object generated;
            XmlTag propTag = rootTag.createChildTag(TAG_NAME, rootTag.getNamespace(), "", false);
            propTag.setAttribute(NAME_ATTR, this.myCanonicalText);
            DomElement contextElement = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement());
            if (contextElement == null) {
                generated = rootTag.addSubTag(propTag, true);
            } else {
                AntDomTarget containingTarget = (AntDomTarget)contextElement.getParentOfType(AntDomTarget.class, false);
                AntDomTarget anchor = containingTarget != null ? containingTarget : contextElement;
                XmlTag tag = anchor.getXmlTag();
                generated = !rootTag.equals(tag) ? tag.getParent().addBefore((PsiElement)propTag, (PsiElement)tag) : rootTag.addSubTag(propTag, true);
            }
            if (generated instanceof XmlTag) {
                result = new OpenFileDescriptor(project, containingFile.getVirtualFile(), generated.getValue().getTextRange().getEndOffset());
            }
            if (result == null && generated instanceof Navigatable) {
                result = (Navigatable)generated;
            }
        }
        if (result != null) {
            result.navigate(true);
        }
    }
}

