/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.CleanupIntention;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

class CleanupOnScopeIntention
extends CleanupIntention {
    static final CleanupOnScopeIntention INSTANCE = new CleanupOnScopeIntention();

    private CleanupOnScopeIntention() {
    }

    @Override
    @Nullable
    protected AnalysisScope getScope(Project project, PsiFile file) {
        BaseAnalysisActionDialog dlg;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        AnalysisScope analysisScope = new AnalysisScope(file);
        VirtualFile virtualFile = file.getVirtualFile();
        if (file.isPhysical() || virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            analysisScope = new AnalysisScope(project);
        }
        if (!(dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, analysisScope, module != null ? module.getName() : null, true, AnalysisUIOptions.getInstance(project), (PsiElement)file)).showAndGet()) {
            return null;
        }
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project);
        return dlg.getScope(uiOptions, analysisScope, project, module);
    }
}

