/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.GotoNextErrorHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.ex.ErrorStripeAdapter;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ErrorStripeHandler
extends ErrorStripeAdapter {
    private final Project myProject;

    public ErrorStripeHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void errorMarkerClicked(@NotNull ErrorStripeEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/ErrorStripeHandler", "errorMarkerClicked"));
        }
        RangeHighlighter highlighter = e.getHighlighter();
        if (!highlighter.isValid()) {
            return;
        }
        HighlightInfo info = ErrorStripeHandler.findInfo(highlighter);
        if (info != null) {
            GotoNextErrorHandler.navigateToError(this.myProject, e.getEditor(), info);
        }
    }

    private static HighlightInfo findInfo(RangeHighlighter highlighter) {
        Object o = highlighter.getErrorStripeTooltip();
        if (o instanceof HighlightInfo) {
            return (HighlightInfo)o;
        }
        return null;
    }
}

