/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.DefaultChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiChangeHandler
extends PsiTreeChangeAdapter
implements Disposable {
    private static final ExtensionPointName<ChangeLocalityDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.daemon.changeLocalityDetector");
    private final Key<Boolean> UPDATE_ON_COMMIT_ENGAGED;
    private final Project myProject;
    private final Map<Document, List<Pair<PsiElement, Boolean>>> changedElements;
    private final FileStatusMap myFileStatusMap;

    PsiChangeHandler(@NotNull Project project, final @NotNull PsiDocumentManagerImpl documentManager, @NotNull EditorFactory editorFactory, @NotNull MessageBusConnection connection, @NotNull FileStatusMap fileStatusMap) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "<init>"));
        }
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "<init>"));
        }
        if (editorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorFactory", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "<init>"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "<init>"));
        }
        if (fileStatusMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatusMap", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "<init>"));
        }
        this.UPDATE_ON_COMMIT_ENGAGED = Key.create((String)"UPDATE_ON_COMMIT_ENGAGED");
        this.changedElements = new THashMap();
        this.myProject = project;
        this.myFileStatusMap = fileStatusMap;
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                final Document document = e.getDocument();
                if (documentManager.getSynchronizer().isInSynchronization(document)) {
                    return;
                }
                if (documentManager.getCachedPsiFile(document) == null) {
                    return;
                }
                if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) == null) {
                    document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, (Object)Boolean.TRUE);
                    PsiDocumentManagerBase.addRunOnCommit(document, new Runnable(){

                        @Override
                        public void run() {
                            if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) != null) {
                                PsiChangeHandler.this.updateChangesForDocument(document);
                                document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
                            }
                        }
                    });
                }
            }
        }, (Disposable)this);
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler$2", "transactionStarted"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler$2", "transactionStarted"));
                }
            }

            @Override
            public void transactionCompleted(@NotNull Document document, @NotNull PsiFile file) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler$2", "transactionCompleted"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler$2", "transactionCompleted"));
                }
                PsiChangeHandler.this.updateChangesForDocument(document);
                document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
            }
        });
    }

    public void dispose() {
    }

    private void updateChangesForDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "updateChangesForDocument"));
        }
        if (DaemonListeners.isUnderIgnoredAction(null) || this.myProject.isDisposed()) {
            return;
        }
        List<Pair<PsiElement, Boolean>> toUpdate = this.changedElements.get(document);
        if (toUpdate == null) {
            if (UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document)) {
                return;
            }
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
            if (file == null) {
                return;
            }
            toUpdate = Collections.singletonList(Pair.create((Object)file, (Object)true));
        }
        Application application = ApplicationManager.getApplication();
        final Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor != null && !application.isUnitTestMode()) {
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!editor.isDisposed()) {
                        EditorMarkupModel markupModel = (EditorMarkupModel)editor.getMarkupModel();
                        PsiFile file = PsiDocumentManager.getInstance((Project)PsiChangeHandler.this.myProject).getPsiFile(editor.getDocument());
                        TrafficLightRenderer.setOrRefreshErrorStripeRenderer(markupModel, PsiChangeHandler.this.myProject, editor.getDocument(), file);
                    }
                }
            }, ModalityState.stateForComponent((Component)editor.getComponent()), this.myProject.getDisposed());
        }
        for (Pair<PsiElement, Boolean> changedElement : toUpdate) {
            PsiElement element = (PsiElement)changedElement.getFirst();
            Boolean whiteSpaceOptimizationAllowed = (Boolean)changedElement.getSecond();
            this.updateByChange(element, document, whiteSpaceOptimizationAllowed);
        }
        this.changedElements.remove(document);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "childAdded"));
        }
        this.queueElement(event.getParent(), true, event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "childRemoved"));
        }
        this.queueElement(event.getParent(), true, event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "childReplaced"));
        }
        this.queueElement(event.getNewChild(), PsiChangeHandler.typesEqual(event.getNewChild(), event.getOldChild()), event);
    }

    private static boolean typesEqual(PsiElement newChild, PsiElement oldChild) {
        return newChild != null && oldChild != null && newChild.getClass() == oldChild.getClass();
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "childrenChanged"));
        }
        if (((PsiTreeChangeEventImpl)event).isGenericChange()) {
            return;
        }
        this.queueElement(event.getParent(), true, event);
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "beforeChildMovement"));
        }
        this.queueElement(event.getOldParent(), true, event);
        this.queueElement(event.getNewParent(), true, event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "beforeChildrenChange"));
        }
        PsiFile psiFile = event.getFile();
        if (psiFile != null) {
            this.myFileStatusMap.markFileScopeDirtyDefensively(psiFile, event);
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "propertyChanged"));
        }
        String propertyName = event.getPropertyName();
        if (!propertyName.equals("writable")) {
            Object oldValue = event.getOldValue();
            if (oldValue instanceof VirtualFile && this.shouldBeIgnored((VirtualFile)oldValue)) {
                return;
            }
            this.myFileStatusMap.markAllFilesDirty(event);
        }
    }

    private void queueElement(@NotNull PsiElement child, boolean whitespaceOptimizationAllowed, @NotNull PsiTreeChangeEvent event) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "queueElement"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "queueElement"));
        }
        PsiFile file = event.getFile();
        if (file == null) {
            file = child.getContainingFile();
        }
        if (file == null) {
            this.myFileStatusMap.markAllFilesDirty(child);
            return;
        }
        if (!child.isValid()) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
        if (document != null) {
            SmartList toUpdate = this.changedElements.get(document);
            if (toUpdate == null) {
                toUpdate = new SmartList();
                this.changedElements.put(document, (List<Pair<PsiElement, Boolean>>)toUpdate);
            }
            toUpdate.add(Pair.create((Object)child, (Object)whitespaceOptimizationAllowed));
        }
    }

    private void updateByChange(@NotNull PsiElement child, @NotNull Document document, boolean whitespaceOptimizationAllowed) {
        PsiElement element;
        PsiFile file;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "updateByChange"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "updateByChange"));
        }
        try {
            file = child.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            this.myFileStatusMap.markAllFilesDirty((Object)e);
            return;
        }
        if (file == null || file instanceof PsiCompiledElement) {
            this.myFileStatusMap.markAllFilesDirty(child);
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && this.shouldBeIgnored(virtualFile)) {
            return;
        }
        int fileLength = file.getTextLength();
        if (!file.getViewProvider().isPhysical()) {
            this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, fileLength), fileLength, "Non-physical file update: " + file);
            return;
        }
        PsiElement psiElement = element = whitespaceOptimizationAllowed && UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document) ? child : child.getParent();
        while (true) {
            if (element == null || element instanceof PsiFile || element instanceof PsiDirectory) {
                this.myFileStatusMap.markAllFilesDirty("Top element: " + element);
                return;
            }
            PsiElement scope = PsiChangeHandler.getChangeHighlightingScope(element);
            if (scope != null) {
                this.myFileStatusMap.markFileScopeDirty(document, scope.getTextRange(), fileLength, "Scope: " + scope);
                return;
            }
            element = element.getParent();
        }
    }

    private boolean shouldBeIgnored(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "shouldBeIgnored"));
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) || ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isExcluded(virtualFile);
    }

    @Nullable
    private static PsiElement getChangeHighlightingScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler", "getChangeHighlightingScope"));
        }
        DefaultChangeLocalityDetector defaultDetector = null;
        for (ChangeLocalityDetector detector : (ChangeLocalityDetector[])Extensions.getExtensions(EP_NAME)) {
            if (detector instanceof DefaultChangeLocalityDetector) {
                assert (defaultDetector == null) : defaultDetector;
                defaultDetector = (DefaultChangeLocalityDetector)detector;
                continue;
            }
            PsiElement scope = detector.getChangeHighlightingDirtyScopeFor(element);
            if (scope == null) continue;
            return scope;
        }
        assert (defaultDetector != null) : "com.intellij.codeInsight.daemon.impl.DefaultChangeLocalityDetector is unregistered";
        return defaultDetector.getChangeHighlightingDirtyScopeFor(element);
    }
}

