/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextEditorBackgroundHighlighter
implements BackgroundEditorHighlighter {
    private static final int[] EXCEPT_OVERRIDDEN = new int[]{1, 3, 4, 7, 12, 8};
    private final Editor myEditor;
    private final Document myDocument;
    private PsiFile myFile;
    private final Project myProject;
    private boolean myCompiled;

    public TextEditorBackgroundHighlighter(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "<init>"));
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
        this.renewFile();
    }

    private void renewFile() {
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
            this.myCompiled = this.myFile instanceof PsiCompiledFile;
            if (this.myCompiled) {
                this.myFile = ((PsiCompiledFile)this.myFile).getDecompiledPsiFile();
            }
            if (this.myFile != null && !this.myFile.isValid()) {
                this.myFile = null;
            }
        }
        if (this.myFile != null) {
            this.myFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
        }
    }

    @NotNull
    List<TextEditorHighlightingPass> getPasses(@NotNull int[] passesToIgnore) {
        if (passesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passesToIgnore", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "getPasses"));
        }
        if (this.myProject.isDisposed()) {
            List<TextEditorHighlightingPass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "getPasses"));
            }
            return list;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.renewFile();
        if (this.myFile == null) {
            List<TextEditorHighlightingPass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "getPasses"));
            }
            return list;
        }
        if (this.myCompiled) {
            passesToIgnore = EXCEPT_OVERRIDDEN;
        } else if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(this.myFile)) {
            List<TextEditorHighlightingPass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "getPasses"));
            }
            return list;
        }
        TextEditorHighlightingPassRegistrarEx passRegistrar = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject);
        List<TextEditorHighlightingPass> list = passRegistrar.instantiatePasses(this.myFile, this.myEditor, passesToIgnore);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "getPasses"));
        }
        return list;
    }

    @NotNull
    public TextEditorHighlightingPass[] createPassesForVisibleArea() {
        TextEditorHighlightingPass[] textEditorHighlightingPassArray = this.createPassesForEditor();
        if (textEditorHighlightingPassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "createPassesForVisibleArea"));
        }
        return textEditorHighlightingPassArray;
    }

    @NotNull
    public TextEditorHighlightingPass[] createPassesForEditor() {
        List<TextEditorHighlightingPass> passes = this.getPasses(ArrayUtil.EMPTY_INT_ARRAY);
        TextEditorHighlightingPass[] textEditorHighlightingPassArray = passes.isEmpty() ? TextEditorHighlightingPass.EMPTY_ARRAY : passes.toArray(new TextEditorHighlightingPass[passes.size()]);
        if (textEditorHighlightingPassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter", "createPassesForEditor"));
        }
        return textEditorHighlightingPassArray;
    }
}

