/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AddXsiSchemaLocationForExtResourceAction
extends BaseExtResourceAction {
    @NonNls
    private static final String XMLNS_XSI_ATTR_NAME = "xmlns:xsi";
    @NonNls
    private static final String XSI_SCHEMA_LOCATION_ATTR_NAME = "xsi:schemaLocation";
    public static final String KEY = "add.xsi.schema.location.for.external.resource";

    @Override
    protected String getQuickFixKeyId() {
        return KEY;
    }

    @Override
    protected void doInvoke(final @NotNull PsiFile file, int offset, final @NotNull String uri, final Editor editor) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction", "doInvoke"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction", "doInvoke"));
        }
        final XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), XmlTag.class);
        if (tag == null) {
            return;
        }
        final ArrayList schemaLocations = new ArrayList();
        CreateNSDeclarationIntentionFix.processExternalUris(new CreateNSDeclarationIntentionFix.TagMetaHandler(tag.getLocalName()), file, new CreateNSDeclarationIntentionFix.ExternalUriProcessor(){

            @Override
            public void process(@NotNull String currentUri, String url) {
                if (currentUri == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentUri", "com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction$1", "process"));
                }
                if (currentUri.equals(uri) && url != null) {
                    schemaLocations.add(url);
                }
            }
        }, true);
        CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(ArrayUtil.toStringArray(schemaLocations), file.getProject(), new CreateNSDeclarationIntentionFix.StringToAttributeProcessor(){

            @Override
            public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NotNull String attrName) throws IncorrectOperationException {
                if (attrName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction$2", "doSomethingWithGivenStringToProduceXmlAttributeNowPlease"));
                }
                AddXsiSchemaLocationForExtResourceAction.doIt(file, editor, uri, tag, attrName);
            }
        }, XmlErrorMessages.message("select.namespace.location.title", new Object[0]), (IntentionAction)this, editor);
    }

    private static void doIt(PsiFile file, Editor editor, String uri, XmlTag tag, String s) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file.getProject());
        if (tag.getAttributeValue(XMLNS_XSI_ATTR_NAME) == null) {
            tag.add((PsiElement)elementFactory.createXmlAttribute(XMLNS_XSI_ATTR_NAME, "http://www.w3.org/2001/XMLSchema-instance"));
        }
        XmlAttribute locationAttribute = tag.getAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME);
        String toInsert = uri + " " + s;
        int offset = s.length();
        if (locationAttribute == null) {
            tag.add((PsiElement)elementFactory.createXmlAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME, toInsert));
        } else {
            String newValue = locationAttribute.getValue() + "\n" + toInsert;
            locationAttribute.setValue(newValue);
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)tag);
        TextRange range = tag.getAttribute(XSI_SCHEMA_LOCATION_ATTR_NAME).getValueElement().getTextRange();
        TextRange textRange = new TextRange(range.getEndOffset() - offset - 1, range.getEndOffset() - 1);
        editor.getCaretModel().moveToOffset(textRange.getStartOffset());
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddXsiSchemaLocationForExtResourceAction", "isAvailable"));
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        XmlAttributeValue value = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
        if (value == null) {
            return false;
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)value, XmlAttribute.class);
        if (attribute != null && attribute.isNamespaceDeclaration()) {
            this.setText(XmlBundle.message((String)this.getQuickFixKeyId(), (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

