/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.BaseMoveHandler;
import com.intellij.codeInsight.editorActions.moveUpDown.MoverWrapper;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoveStatementHandler
extends BaseMoveHandler {
    public MoveStatementHandler(boolean down) {
        super(down);
    }

    @Override
    @Nullable
    protected MoverWrapper getSuitableMover(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/moveUpDown/MoveStatementHandler", "getSuitableMover"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/moveUpDown/MoveStatementHandler", "getSuitableMover"));
        }
        StatementUpDownMover[] movers = (StatementUpDownMover[])Extensions.getExtensions((ExtensionPointName)StatementUpDownMover.STATEMENT_UP_DOWN_MOVER_EP);
        StatementUpDownMover.MoveInfo info = new StatementUpDownMover.MoveInfo();
        for (StatementUpDownMover mover : movers) {
            if (!mover.checkAvailable(editor, file, info, this.isDown)) continue;
            return new MoverWrapper(mover, info, this.isDown);
        }
        return null;
    }
}

