/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ExpandAllRegionsAction
extends EditorAction {
    public ExpandAllRegionsAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(final Editor editor, @Nullable Caret caret, DataContext dataContext) {
                Project project = editor.getProject();
                assert (project != null);
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                CodeFoldingManager.getInstance(project).updateFoldRegions(editor);
                final List<FoldRegion> regions = this.getFoldRegionsForSelection(editor, caret);
                editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                    @Override
                    public void run() {
                        boolean anythingDone = false;
                        for (FoldRegion region : regions) {
                            PsiElement element = EditorFoldingInfo.get(editor).getPsiElement(region);
                            if (region.isExpanded() || element != null && FoldingPolicy.isCollapseByDefault(element)) continue;
                            region.setExpanded(true);
                            anythingDone = true;
                        }
                        if (!anythingDone) {
                            for (FoldRegion region : regions) {
                                region.setExpanded(true);
                            }
                        }
                    }
                });
            }
        });
    }
}

