/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.generation.surroundWith.JavaWithBlockSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithDoWhileSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithForSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfElseSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithRunnableSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithSynchronizedSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithTryCatchFinallySurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithTryCatchSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithTryFinallySurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithWhileSurrounder;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JavaStatementsSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new JavaWithIfSurrounder(), new JavaWithIfElseSurrounder(), new JavaWithWhileSurrounder(), new JavaWithDoWhileSurrounder(), new JavaWithForSurrounder(), new JavaWithTryCatchSurrounder(), new JavaWithTryFinallySurrounder(), new JavaWithTryCatchFinallySurrounder(), new JavaWithSynchronizedSurrounder(), new JavaWithRunnableSurrounder(), new JavaWithBlockSurrounder()};

    @NotNull
    public Surrounder[] getSurrounders() {
        if (SURROUNDERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/surroundWith/JavaStatementsSurroundDescriptor", "getSurrounders"));
        }
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement[] statements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset);
        if (statements.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/surroundWith/JavaStatementsSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.surroundwith.statement");
        if (statements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/surroundWith/JavaStatementsSurroundDescriptor", "getElementsToSurround"));
        }
        return statements;
    }
}

