/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.EmmetPreviewUtil;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class EmmetPreviewAction
extends BaseCodeInsightAction
implements DumbAware,
PopupAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/emmet/EmmetPreviewAction$1", "invoke"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetPreviewAction$1", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetPreviewAction$1", "invoke"));
                }
                String templateText = EmmetPreviewUtil.calculateTemplateText(editor, file, true);
                if (StringUtil.isEmpty((String)templateText)) {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot show preview for given abbreviation", (String)"Emmet Preview", null);
                    return;
                }
                EmmetPreviewHint.createHint((EditorEx)editor, templateText, file.getFileType()).showHint();
                EmmetPreviewUtil.addEmmetPreviewListeners(editor, file, true);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        if (codeInsightActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewAction", "getHandler"));
        }
        return codeInsightActionHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/emmet/EmmetPreviewAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetPreviewAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/EmmetPreviewAction", "isValidForFile"));
        }
        return super.isValidForFile(project, editor, file) && file instanceof XmlFile && ZenCodingTemplate.findApplicableDefaultGenerator(CustomTemplateCallback.getContext(file, CustomTemplateCallback.getOffset(editor)), false) != null;
    }
}

