/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomLiveTemplateLookupElement
extends LiveTemplateLookupElement {
    @NotNull
    private final CustomLiveTemplateBase myCustomLiveTemplate;
    @NotNull
    private final String myTemplateKey;
    @NotNull
    private final String myItemText;

    public CustomLiveTemplateLookupElement(@NotNull CustomLiveTemplateBase customLiveTemplate, @NotNull String templateKey, @NotNull String itemText, @Nullable String description, boolean sudden, boolean worthShowingInAutoPopup) {
        if (customLiveTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customLiveTemplate", "com/intellij/codeInsight/template/impl/CustomLiveTemplateLookupElement", "<init>"));
        }
        if (templateKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateKey", "com/intellij/codeInsight/template/impl/CustomLiveTemplateLookupElement", "<init>"));
        }
        if (itemText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemText", "com/intellij/codeInsight/template/impl/CustomLiveTemplateLookupElement", "<init>"));
        }
        super(templateKey, description, sudden, worthShowingInAutoPopup);
        this.myCustomLiveTemplate = customLiveTemplate;
        this.myTemplateKey = templateKey;
        this.myItemText = itemText;
    }

    @Override
    @NotNull
    protected String getItemText() {
        String string = this.myItemText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/CustomLiveTemplateLookupElement", "getItemText"));
        }
        return string;
    }

    @NotNull
    public CustomLiveTemplateBase getCustomLiveTemplate() {
        CustomLiveTemplateBase customLiveTemplateBase = this.myCustomLiveTemplate;
        if (customLiveTemplateBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/CustomLiveTemplateLookupElement", "getCustomLiveTemplate"));
        }
        return customLiveTemplateBase;
    }

    @Override
    public char getTemplateShortcut() {
        return this.myCustomLiveTemplate.getShortcut();
    }

    public void handleInsert(InsertionContext context) {
        context.setAddCompletionChar(false);
        this.expandTemplate(context.getEditor(), context.getFile());
    }

    public void expandTemplate(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/CustomLiveTemplateLookupElement", "expandTemplate"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/CustomLiveTemplateLookupElement", "expandTemplate"));
        }
        this.myCustomLiveTemplate.expand(this.myTemplateKey, new CustomTemplateCallback(editor, file));
    }
}

