/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.TemplateCompletionProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCompleteMacro
extends Macro {
    private final String myName;

    protected BaseCompleteMacro(@NonNls String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public String getPresentableName() {
        return this.myName + "()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/BaseCompleteMacro", "getDefaultValue"));
        }
        return "a";
    }

    public final Result calculateResult(@NotNull Expression[] params, final ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/BaseCompleteMacro", "calculateResult"));
        }
        return new InvokeActionResult(new Runnable(){

            @Override
            public void run() {
                BaseCompleteMacro.this.invokeCompletion(context);
            }
        });
    }

    private void invokeCompletion(final ExpressionContext context) {
        final Project project = context.getProject();
        final Editor editor = context.getEditor();
        final PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed() || editor.isDisposed() || psiFile == null || !psiFile.isValid()) {
                    return;
                }
                if (CompletionServiceImpl.getCompletionService().getCurrentCompletion() != null) {
                    return;
                }
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                        BaseCompleteMacro.this.invokeCompletionHandler(project, editor);
                        LookupEx lookup = LookupManager.getInstance(project).getActiveLookup();
                        if (lookup != null) {
                            lookup.addLookupListener(new MyLookupListener(context));
                        } else {
                            BaseCompleteMacro.considerNextTab(editor);
                        }
                    }
                }, "", null);
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    private static void considerNextTab(Editor editor) {
        TextRange range;
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null && (range = templateState.getCurrentVariableRange()) != null && range.getLength() > 0) {
            int caret = editor.getCaretModel().getOffset();
            if (caret == range.getEndOffset()) {
                templateState.nextTab();
            } else if (caret > range.getEndOffset()) {
                templateState.gotoEnd(true);
            }
        }
    }

    protected abstract void invokeCompletionHandler(Project var1, Editor var2);

    private static class MyLookupListener
    extends LookupAdapter {
        private final ExpressionContext myContext;

        public MyLookupListener(@NotNull ExpressionContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/macro/BaseCompleteMacro$MyLookupListener", "<init>"));
            }
            this.myContext = context;
        }

        @Override
        public void itemSelected(LookupEvent event) {
            LookupElement item = event.getItem();
            if (item == null) {
                return;
            }
            char c = event.getCompletionChar();
            if (!LookupEvent.isSpecialCompletionChar((char)c)) {
                return;
            }
            for (TemplateCompletionProcessor processor2 : (TemplateCompletionProcessor[])Extensions.getExtensions(TemplateCompletionProcessor.EP_NAME)) {
                if (processor2.nextTabOnItemSelected(this.myContext, item)) continue;
                return;
            }
            final Project project = this.myContext.getProject();
            if (project == null) {
                return;
            }
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    new WriteCommandAction(project, new PsiFile[0]){

                        protected void run(@NotNull com.intellij.openapi.application.Result result2) throws Throwable {
                            if (result2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/template/macro/BaseCompleteMacro$MyLookupListener$1$1", "run"));
                            }
                            Editor editor = MyLookupListener.this.myContext.getEditor();
                            if (editor != null) {
                                BaseCompleteMacro.considerNextTab(editor);
                            }
                        }
                    }.execute();
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable2.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.current(), project.getDisposed());
            }
        }
    }
}

