/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MethodParametersMacro
extends Macro {
    public String getName() {
        return "methodParameters";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.method.parameters", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/MethodParametersMacro", "getDefaultValue"));
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/MethodParametersMacro", "calculateResult"));
        }
        for (PsiElement place = context.getPsiElementAtStartOffset(); place != null; place = place.getParent()) {
            if (!(place instanceof PsiMethod)) continue;
            ArrayList<Result> result2 = new ArrayList<Result>();
            for (PsiParameter parameter : ((PsiMethod)place).getParameterList().getParameters()) {
                result2.add((Result)new TextResult(parameter.getName()));
            }
            return new ListResult(result2);
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

