/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;

final class Method {
    final String internalClassName;
    final String methodName;
    final String methodDesc;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        return this.internalClassName.equals(method.internalClassName) && this.methodDesc.equals(method.methodDesc) && this.methodName.equals(method.methodName);
    }

    public int hashCode() {
        int result2 = this.internalClassName.hashCode();
        result2 = 31 * result2 + this.methodName.hashCode();
        result2 = 31 * result2 + this.methodDesc.hashCode();
        return result2;
    }

    Method(String internalClassName, String methodName, String methodDesc) {
        this.internalClassName = internalClassName;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    Method(MethodInsnNode mNode) {
        this.internalClassName = mNode.owner;
        this.methodName = mNode.name;
        this.methodDesc = mNode.desc;
    }

    public String toString() {
        return this.internalClassName + ' ' + this.methodName + ' ' + this.methodDesc;
    }
}

