/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

class ResultUtil<Id, T extends Enum<T>> {
    private final ELattice<T> lattice;
    final T top;

    ResultUtil(ELattice<T> lattice) {
        this.lattice = lattice;
        this.top = lattice.top;
    }

    Result<Id, T> join(Result<Id, T> r1, Result<Id, T> r2) throws AnalyzerException {
        if (r1 instanceof Final && ((Final)r1).value == this.top) {
            return r1;
        }
        if (r2 instanceof Final && ((Final)r2).value == this.top) {
            return r2;
        }
        if (r1 instanceof Final && r2 instanceof Final) {
            return new Final(this.lattice.join((Enum)((Final)r1).value, (Enum)((Final)r2).value));
        }
        if (r1 instanceof Final && r2 instanceof Pending) {
            Final f1 = (Final)r1;
            Pending pending = (Pending)r2;
            HashSet sum1 = new HashSet(pending.sum);
            sum1.add(new Product(f1.value, Collections.emptySet()));
            return new Pending(sum1);
        }
        if (r1 instanceof Pending && r2 instanceof Final) {
            Final f2 = (Final)r2;
            Pending pending = (Pending)r1;
            HashSet sum1 = new HashSet(pending.sum);
            sum1.add(new Product(f2.value, Collections.emptySet()));
            return new Pending(sum1);
        }
        Pending pending1 = (Pending)r1;
        Pending pending2 = (Pending)r2;
        HashSet<Product<Id, T>> sum = new HashSet<Product<Id, T>>();
        sum.addAll(pending1.sum);
        sum.addAll(pending2.sum);
        this.checkLimit(sum);
        return new Pending<Id, T>(sum);
    }

    private void checkLimit(Set<Product<Id, T>> sum) throws AnalyzerException {
        int size = 0;
        for (Product<Id, T> prod : sum) {
            size += prod.ids.size();
        }
        if (size > 30) {
            throw new AnalyzerException(null, "Equation size is too big");
        }
    }
}

