/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAttributeValueIntentionFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public AddAttributeValueIntentionFix(@Nullable PsiElement element) {
        super(element);
    }

    @NotNull
    public String getText() {
        String string = XmlErrorMessages.message("add.attribute.value.quickfix.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/AddAttributeValueIntentionFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/AddAttributeValueIntentionFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, final @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/AddAttributeValueIntentionFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/htmlInspections/AddAttributeValueIntentionFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/htmlInspections/AddAttributeValueIntentionFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/htmlInspections/AddAttributeValueIntentionFix", "invoke"));
        }
        final XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{XmlAttribute.class});
        if (attribute == null || attribute.getValue() != null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(attribute.getContainingFile())) {
            return;
        }
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result2) {
                XmlAttributeValue valueElement;
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/htmlInspections/AddAttributeValueIntentionFix$1", "run"));
                }
                XmlAttribute attributeWithValue = XmlElementFactory.getInstance((Project)this.getProject()).createXmlAttribute(attribute.getName(), "");
                PsiElement newAttribute = attribute.replace((PsiElement)attributeWithValue);
                if (editor != null && newAttribute != null && newAttribute instanceof XmlAttribute && newAttribute.isValid() && (valueElement = ((XmlAttribute)newAttribute).getValueElement()) != null) {
                    editor.getCaretModel().moveToOffset(valueElement.getTextOffset());
                    AutoPopupController.getInstance(newAttribute.getProject()).scheduleAutoPopup(editor);
                }
            }
        }.execute();
    }
}

