/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.java18StreamApi.GuavaFunctionAndPredicateConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nullable;

abstract class FluentIterableMethodTransformer {
    private static final Logger LOG = Logger.getInstance(FluentIterableMethodTransformer.class);

    FluentIterableMethodTransformer() {
    }

    protected abstract String formatMethod(PsiExpression[] var1);

    protected boolean negate() {
        return false;
    }

    @Nullable
    public final PsiMethodCallExpression transform(PsiMethodCallExpression expression, PsiElementFactory elementFactory) {
        String formatted = this.formatMethod(expression.getArgumentList().getExpressions());
        String negation = this.negate() ? "!" : "";
        PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
        LOG.assertTrue(qualifierExpression != null);
        String oldQualifierText = qualifierExpression.getText();
        String expressionText = negation + oldQualifierText + "." + formatted;
        PsiElement replaced = expression.replace((PsiElement)elementFactory.createExpressionFromText(expressionText, null));
        if (replaced instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)replaced;
            while (true) {
                PsiExpression qualifier;
                LOG.assertTrue((qualifier = methodCallExpression.getMethodExpression().getQualifierExpression()) != null);
                if (oldQualifierText.equals(qualifier.getText())) {
                    return methodCallExpression;
                }
                methodCallExpression = (PsiMethodCallExpression)qualifier;
            }
        }
        return null;
    }

    static class ParameterlessMethodTransformer
    extends FluentIterableMethodTransformer {
        private final String myTemplate;
        private final boolean myNegation;

        ParameterlessMethodTransformer(String template) {
            this(template.endsWith(")") ? template : template + "()", false);
        }

        ParameterlessMethodTransformer(String template, boolean negation) {
            this.myTemplate = template;
            this.myNegation = negation;
        }

        @Override
        protected boolean negate() {
            return this.myNegation;
        }

        @Override
        protected String formatMethod(PsiExpression[] initialMethodParameters) {
            return this.myTemplate;
        }
    }

    static class ToArrayMethodTransformer
    extends FluentIterableMethodTransformer {
        ToArrayMethodTransformer() {
        }

        @Override
        protected String formatMethod(PsiExpression[] initialMethodParameters) {
            String qName;
            PsiClass resolvedClass;
            PsiType type;
            PsiExpression parameter = initialMethodParameters[0];
            if (parameter instanceof PsiClassObjectAccessExpression && (type = ((PsiClassObjectAccessExpression)parameter).getOperand().getType()) instanceof PsiClassType && (resolvedClass = ((PsiClassType)type).resolve()) != null && (qName = resolvedClass.getQualifiedName()) != null) {
                return String.format("toArray(%s[]::new)", qName);
            }
            return "toArray()";
        }
    }

    static class OneParameterMethodTransformer
    extends FluentIterableMethodTransformer {
        private final String myTemplate;
        private final boolean myParameterIsFunctionOrPredicate;

        OneParameterMethodTransformer(String template, boolean parameterIsFunctionOrPredicate) {
            this.myTemplate = template;
            this.myParameterIsFunctionOrPredicate = parameterIsFunctionOrPredicate;
        }

        OneParameterMethodTransformer(String parameterIsFunctionOrPredicate) {
            this(parameterIsFunctionOrPredicate, false);
        }

        @Override
        protected String formatMethod(PsiExpression[] initialMethodParameters) {
            Boolean role;
            PsiExpression parameter;
            PsiType type;
            String matchedElementText = this.myParameterIsFunctionOrPredicate ? (initialMethodParameters.length == 1 ? (!((type = (parameter = initialMethodParameters[0]).getType()) instanceof PsiMethodReferenceType) && !(type instanceof PsiLambdaExpressionType) && (role = GuavaFunctionAndPredicateConverter.isClassConditionPredicate(parameter)) != null ? GuavaFunctionAndPredicateConverter.convertFunctionOrPredicateParameter(parameter, role) : parameter.getText()) : "") : (initialMethodParameters.length > 0 ? initialMethodParameters[0].getText() : "");
            return String.format(this.myTemplate, matchedElementText);
        }
    }
}

