/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.model.MetaModel;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.util.IconLoader;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class DefaultPaletteItem
implements PaletteItem {
    private final String myTitle;
    protected final String myIconPath;
    protected Icon myIcon;
    private final String myTooltip;
    private final String myVersion;
    private boolean myEnabled = true;
    private final String myDeprecatedVersion;
    private final String myDeprecatedHint;
    protected MetaModel myMetaModel;

    public DefaultPaletteItem(Element palette) {
        this(palette.getAttributeValue("title"), palette.getAttributeValue("icon"), palette.getAttributeValue("tooltip"), palette.getAttributeValue("version"), palette.getAttributeValue("deprecated"), palette.getAttributeValue("deprecatedHint"));
    }

    public DefaultPaletteItem(String title, String iconPath, String tooltip, String version, String deprecatedVersion, String deprecatedHint) {
        this.myTitle = title;
        this.myIconPath = iconPath;
        this.myTooltip = tooltip;
        this.myVersion = version;
        this.myDeprecatedVersion = deprecatedVersion;
        this.myDeprecatedHint = deprecatedHint;
    }

    @Override
    public String getTitle() {
        return this.myTitle;
    }

    @Override
    public Icon getIcon() {
        if (this.myIcon == null) {
            this.myIcon = IconLoader.findIcon((String)this.myIconPath, this.myMetaModel.getModel());
        }
        return this.myIcon;
    }

    @Override
    public String getTooltip() {
        return this.myTooltip;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    @Nullable
    public String getDeprecatedIn() {
        return this.myDeprecatedVersion;
    }

    @Override
    @Nullable
    public String getDeprecatedHint() {
        return this.myDeprecatedHint;
    }

    @Override
    public String getCreation() {
        return this.myMetaModel.getCreation();
    }

    @Override
    public MetaModel getMetaModel() {
        return this.myMetaModel;
    }

    @Override
    public void setMetaModel(MetaModel metaModel) {
        this.myMetaModel = metaModel;
    }
}

