/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import org.jetbrains.annotations.NotNull;

class ChangedBlock {
    private final int myStartOffset1;
    private final int myEndOffset1;
    private final int myStartOffset2;
    private final int myEndOffset2;
    private final int myLine1;
    private final int myLine2;
    @NotNull
    private final LineFragment myLineFragment;

    public ChangedBlock(int startOffset1, int endOffset1, int startOffset2, int endOffset2, int line1, int line2, @NotNull LineFragment lineFragment) {
        if (lineFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragment", "com/intellij/diff/tools/fragmented/ChangedBlock", "<init>"));
        }
        this.myStartOffset1 = startOffset1;
        this.myEndOffset1 = endOffset1;
        this.myStartOffset2 = startOffset2;
        this.myEndOffset2 = endOffset2;
        this.myLine1 = line1;
        this.myLine2 = line2;
        this.myLineFragment = lineFragment;
    }

    @NotNull
    public static ChangedBlock createInserted(int length, int lines) {
        LineFragmentImpl lineFragment = new LineFragmentImpl(0, 0, 0, lines, 0, 0, 0, length);
        ChangedBlock changedBlock = new ChangedBlock(0, 0, 0, length, 0, lines, (LineFragment)lineFragment);
        if (changedBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/ChangedBlock", "createInserted"));
        }
        return changedBlock;
    }

    @NotNull
    public static ChangedBlock createDeleted(int length, int lines) {
        LineFragmentImpl lineFragment = new LineFragmentImpl(0, lines, 0, 0, 0, length, 0, 0);
        ChangedBlock changedBlock = new ChangedBlock(0, length, 0, 0, 0, lines, (LineFragment)lineFragment);
        if (changedBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/ChangedBlock", "createDeleted"));
        }
        return changedBlock;
    }

    public int getStartOffset1() {
        return this.myStartOffset1;
    }

    public int getEndOffset1() {
        return this.myEndOffset1;
    }

    public int getStartOffset2() {
        return this.myStartOffset2;
    }

    public int getEndOffset2() {
        return this.myEndOffset2;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    @NotNull
    public LineFragment getLineFragment() {
        LineFragment lineFragment = this.myLineFragment;
        if (lineFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/ChangedBlock", "getLineFragment"));
        }
        return lineFragment;
    }
}

