/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.SoftValueHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftHardCacheMap<K, V> {
    @NotNull
    private final SLRUMap<K, V> mySLRUMap;
    @NotNull
    private final SoftValueHashMap<K, V> mySoftLinkMap;

    public SoftHardCacheMap(int protectedQueueSize, int probationalQueueSize) {
        this.mySLRUMap = new SLRUMap(protectedQueueSize, probationalQueueSize);
        this.mySoftLinkMap = new SoftValueHashMap();
    }

    @Nullable
    public V get(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/tools/util/SoftHardCacheMap", "get"));
        }
        Object val = this.mySLRUMap.get(key);
        if (val != null) {
            return (V)val;
        }
        val = this.mySoftLinkMap.get(key);
        if (val != null) {
            this.mySLRUMap.put(key, val);
        }
        return (V)val;
    }

    public void put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/tools/util/SoftHardCacheMap", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diff/tools/util/SoftHardCacheMap", "put"));
        }
        this.mySLRUMap.put(key, value);
        this.mySoftLinkMap.put(key, value);
    }

    public boolean remove(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/tools/util/SoftHardCacheMap", "remove"));
        }
        boolean remove1 = this.mySLRUMap.remove(key);
        boolean remove2 = this.mySoftLinkMap.remove(key) != null;
        return remove1 || remove2;
    }

    public void clear() {
        this.mySLRUMap.clear();
        this.mySoftLinkMap.clear();
    }
}

