/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.ThreeDiffSplitter;
import com.intellij.diff.tools.util.side.HolderPanel;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreesideContentPanel
extends JPanel {
    @NotNull
    private final ThreeDiffSplitter mySplitter;
    @Nullable
    private final EditorEx myBaseEditor;

    public ThreesideContentPanel(@NotNull List<? extends EditorHolder> holders, @NotNull List<JComponent> titleComponents) {
        if (holders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/side/ThreesideContentPanel", "<init>"));
        }
        if (titleComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleComponents", "com/intellij/diff/tools/util/side/ThreesideContentPanel", "<init>"));
        }
        super(new BorderLayout());
        assert (holders.size() == 3);
        assert (titleComponents.size() == 3);
        EditorHolder baseHolder = (EditorHolder)ThreeSide.BASE.select(holders);
        this.myBaseEditor = baseHolder instanceof TextEditorHolder ? ((TextEditorHolder)baseHolder).getEditor() : null;
        ArrayList<HolderPanel> components = new ArrayList<HolderPanel>(3);
        for (int i = 0; i < 3; ++i) {
            components.add(new HolderPanel(holders.get(i), titleComponents.get(i)));
        }
        this.mySplitter = new ThreeDiffSplitter(components);
        this.add((Component)this.mySplitter, "Center");
    }

    public void setPainter(@Nullable DiffSplitter.Painter painter, @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideContentPanel", "setPainter"));
        }
        this.mySplitter.setPainter(painter, side);
    }

    public void repaintDividers() {
        if (this.myBaseEditor != null) {
            this.myBaseEditor.getScrollPane().getVerticalScrollBar().repaint();
        }
        this.mySplitter.repaintDividers();
    }

    public void repaintDivider(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideContentPanel", "repaintDivider"));
        }
        if (side == Side.RIGHT && this.myBaseEditor != null) {
            this.myBaseEditor.getScrollPane().getVerticalScrollBar().repaint();
        }
        this.mySplitter.repaintDivider(side);
    }

    public void setScrollbarPainter(@NotNull ButtonlessScrollBarUI.ScrollbarRepaintCallback painter) {
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/diff/tools/util/side/ThreesideContentPanel", "setScrollbarPainter"));
        }
        if (this.myBaseEditor != null) {
            this.myBaseEditor.registerScrollBarRepaintCallback(painter);
        }
    }
}

