/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoveryIndex
implements ProjectComponent {
    static final Logger LOG = Logger.getInstance(TestDiscoveryIndex.class);
    private static final int REMOVED_MARKER = -1;
    private final Object ourLock = new Object();
    private final Project myProject;
    private volatile Holder myHolder;
    private static final int VERSION = 2;

    public TestDiscoveryIndex(Project project) {
        this.myProject = project;
        String path = TestDiscoveryExtension.baseTestDiscoveryPathForProject(this.myProject);
        if (new File(path).exists()) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            TestDiscoveryIndex.this.getHolder();
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTestTrace(@NotNull String testName) throws IOException {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/execution/testDiscovery/TestDiscoveryIndex", "hasTestTrace"));
        }
        Object object = this.ourLock;
        synchronized (object) {
            Holder holder = null;
            try {
                holder = this.getHolder();
                int testNameId = holder.myTestNameEnumerator.tryEnumerate((Object)testName);
                if (testNameId == 0) {
                    return false;
                }
                return holder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId) != null;
            }
            catch (Throwable throwable) {
                this.thingsWentWrongLetsReinitialize(holder, throwable);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestTrace(@NotNull String testName) throws IOException {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/execution/testDiscovery/TestDiscoveryIndex", "removeTestTrace"));
        }
        Object object = this.ourLock;
        synchronized (object) {
            Holder holder = null;
            try {
                holder = this.getHolder();
                int testNameId = holder.myTestNameEnumerator.tryEnumerate((Object)testName);
                if (testNameId == 0) {
                    return;
                }
                this.doUpdateFromDiff(holder, testNameId, null, (TIntObjectHashMap<TIntArrayList>)((TIntObjectHashMap)holder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId)));
            }
            catch (Throwable throwable) {
                this.thingsWentWrongLetsReinitialize(holder, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getTestsByMethodName(@NotNull String classFQName, @NotNull String methodName) throws IOException {
        if (classFQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFQName", "com/intellij/execution/testDiscovery/TestDiscoveryIndex", "getTestsByMethodName"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/execution/testDiscovery/TestDiscoveryIndex", "getTestsByMethodName"));
        }
        Object object = this.ourLock;
        synchronized (object) {
            Holder holder = null;
            try {
                holder = this.getHolder();
                TIntArrayList list = (TIntArrayList)holder.myMethodQNameToTestNames.get((Object)TestDiscoveryIndex.createKey(holder.myClassEnumerator.enumerate(classFQName), holder.myMethodEnumerator.enumerate(methodName)));
                if (list == null) {
                    return Collections.emptyList();
                }
                ArrayList<String> result2 = new ArrayList<String>(list.size());
                for (int testNameId : list.toNativeArray()) {
                    result2.add(holder.myTestNameEnumerator.valueOf(testNameId));
                }
                return result2;
            }
            catch (Throwable throwable) {
                this.thingsWentWrongLetsReinitialize(holder, throwable);
                return Collections.emptyList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder getHolder() {
        Holder holder = this.myHolder;
        if (holder == null) {
            Object object = this.ourLock;
            synchronized (object) {
                holder = this.myHolder;
                if (holder == null) {
                    holder = this.myHolder = new Holder();
                }
            }
        }
        return holder;
    }

    public static TestDiscoveryIndex getInstance(Project project) {
        return (TestDiscoveryIndex)project.getComponent(TestDiscoveryIndex.class);
    }

    public void initComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponent() {
        Object object = this.ourLock;
        synchronized (object) {
            Holder holder = this.myHolder;
            if (holder != null) {
                holder.dispose();
                this.myHolder = null;
            }
        }
    }

    @NotNull
    public String getComponentName() {
        String string = this.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryIndex", "getComponentName"));
        }
        return string;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void updateFromTestTrace(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/testDiscovery/TestDiscoveryIndex", "updateFromTestTrace"));
        }
        int fileNameDotIndex = file.getName().lastIndexOf(46);
        String testName = fileNameDotIndex != -1 ? file.getName().substring(0, fileNameDotIndex) : file.getName();
        this.doUpdateFromTestTrace(file, testName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateFromTestTrace(File file, String testName) throws IOException {
        Object object = this.ourLock;
        synchronized (object) {
            Holder holder = this.getHolder();
            if (holder.myDisposed) {
                return;
            }
            try {
                int testNameId = holder.myTestNameEnumerator.enumerate(testName);
                TIntObjectHashMap<TIntArrayList> classData = TestDiscoveryIndex.loadClassAndMethodsMap(file, holder);
                TIntObjectHashMap previousClassData = (TIntObjectHashMap)holder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId);
                this.doUpdateFromDiff(holder, testNameId, classData, (TIntObjectHashMap<TIntArrayList>)previousClassData);
            }
            catch (Throwable throwable) {
                this.thingsWentWrongLetsReinitialize(holder, throwable);
            }
        }
    }

    private void doUpdateFromDiff(Holder holder, final int testNameId, @Nullable TIntObjectHashMap<TIntArrayList> classData, @Nullable TIntObjectHashMap<TIntArrayList> previousClassData) throws IOException {
        ValueDiff valueDiff = new ValueDiff(classData, previousClassData);
        if (valueDiff.hasRemovedDelta()) {
            for (int classQName : valueDiff.myRemovedClassData.keys()) {
                for (int methodName : ((TIntArrayList)valueDiff.myRemovedClassData.get(classQName)).toNativeArray()) {
                    holder.myMethodQNameToTestNames.appendData((Object)TestDiscoveryIndex.createKey(classQName, methodName), new PersistentHashMap.ValueDataAppender(){

                        public void append(DataOutput dataOutput) throws IOException {
                            DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)-1);
                            DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId);
                        }
                    });
                }
            }
        }
        if (valueDiff.hasAddedDelta()) {
            for (int classQName : valueDiff.myAddedOrChangedClassData.keys()) {
                for (int methodName : ((TIntArrayList)valueDiff.myAddedOrChangedClassData.get(classQName)).toNativeArray()) {
                    holder.myMethodQNameToTestNames.appendData((Object)TestDiscoveryIndex.createKey(classQName, methodName), new PersistentHashMap.ValueDataAppender(){

                        public void append(DataOutput dataOutput) throws IOException {
                            DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId);
                        }
                    });
                }
            }
        }
        if (valueDiff.hasAddedDelta() || valueDiff.hasRemovedDelta()) {
            if (classData != null) {
                holder.myTestNameToUsedClassesAndMethodMap.put((Object)testNameId, classData);
            } else {
                holder.myTestNameToUsedClassesAndMethodMap.remove((Object)testNameId);
            }
        }
    }

    @NotNull
    private static File getVersionFile(String path) {
        File file = new File(path + File.separator + "index.version");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryIndex", "getVersionFile"));
        }
        return file;
    }

    private void thingsWentWrongLetsReinitialize(@Nullable Holder holder, Throwable throwable) throws IOException {
        LOG.error("Unexpected problem", throwable);
        if (holder != null) {
            holder.dispose();
        }
        String path = TestDiscoveryExtension.baseTestDiscoveryPathForProject(this.myProject);
        File versionFile = TestDiscoveryIndex.getVersionFile(path);
        FileUtil.delete((File)versionFile);
        this.myHolder = null;
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
    }

    private static long createKey(int classQName, int methodName) {
        return (long)classQName << 32 | (long)methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static TIntObjectHashMap<TIntArrayList> loadClassAndMethodsMap(File file, Holder holder) throws IOException {
        DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file), 65536));
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        int numberOfClasses = DataInputOutputUtil.readINT((DataInput)inputStream);
        TIntObjectHashMap classData = new TIntObjectHashMap(numberOfClasses);
        while (numberOfClasses-- > 0) {
            String classQName = IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream);
            int classId = holder.myClassEnumeratorCache.enumerate((Object)classQName);
            int numberOfMethods = DataInputOutputUtil.readINT((DataInput)inputStream);
            TIntArrayList methodsList = new TIntArrayList(numberOfMethods);
            while (numberOfMethods-- > 0) {
                String methodName = IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream);
                methodsList.add(holder.myMethodEnumeratorCache.enumerate((Object)methodName));
            }
            classData.put(classId, (Object)methodsList);
        }
        TIntObjectHashMap tIntObjectHashMap = classData;
        TIntObjectHashMap tIntObjectHashMap2 = tIntObjectHashMap;
        if (tIntObjectHashMap2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testDiscovery/TestDiscoveryIndex", "loadClassAndMethodsMap"));
        }
        return tIntObjectHashMap2;
        finally {
            inputStream.close();
        }
    }

    static class ValueDiff {
        final TIntObjectHashMap<TIntArrayList> myAddedOrChangedClassData;
        final TIntObjectHashMap<TIntArrayList> myRemovedClassData;

        ValueDiff(@Nullable TIntObjectHashMap<TIntArrayList> classData, @Nullable TIntObjectHashMap<TIntArrayList> previousClassData) {
            TIntObjectHashMap addedOrChangedClassData = classData;
            TIntObjectHashMap removedClassData = previousClassData;
            if (previousClassData != null && !previousClassData.isEmpty()) {
                removedClassData = new TIntObjectHashMap();
                addedOrChangedClassData = new TIntObjectHashMap();
                if (classData != null) {
                    for (int classQName : classData.keys()) {
                        TIntArrayList currentMethods = (TIntArrayList)classData.get(classQName);
                        TIntArrayList previousMethods = (TIntArrayList)previousClassData.get(classQName);
                        if (previousMethods == null) {
                            addedOrChangedClassData.put(classQName, (Object)currentMethods);
                            continue;
                        }
                        int[] previousMethodIds = previousMethods.toNativeArray();
                        TIntHashSet previousMethodsSet = new TIntHashSet(previousMethodIds);
                        int[] currentMethodIds = currentMethods.toNativeArray();
                        TIntHashSet currentMethodsSet = new TIntHashSet(currentMethodIds);
                        currentMethodsSet.removeAll(previousMethodIds);
                        previousMethodsSet.removeAll(currentMethodIds);
                        if (!currentMethodsSet.isEmpty()) {
                            addedOrChangedClassData.put(classQName, (Object)new TIntArrayList(currentMethodsSet.toArray()));
                        }
                        if (previousMethodsSet.isEmpty()) continue;
                        removedClassData.put(classQName, (Object)new TIntArrayList(previousMethodsSet.toArray()));
                    }
                }
                if (classData != null) {
                    for (int classQName : previousClassData.keys()) {
                        if (classData.containsKey(classQName)) continue;
                        TIntArrayList previousMethods = (TIntArrayList)previousClassData.get(classQName);
                        removedClassData.put(classQName, (Object)previousMethods);
                    }
                }
            }
            this.myAddedOrChangedClassData = addedOrChangedClassData;
            this.myRemovedClassData = removedClassData;
        }

        public boolean hasRemovedDelta() {
            return this.myRemovedClassData != null && !this.myRemovedClassData.isEmpty();
        }

        public boolean hasAddedDelta() {
            return this.myAddedOrChangedClassData != null && !this.myAddedOrChangedClassData.isEmpty();
        }
    }

    private static class MethodQNameSerializer
    implements KeyDescriptor<Long> {
        public static final MethodQNameSerializer INSTANCE = new MethodQNameSerializer();

        private MethodQNameSerializer() {
        }

        public void save(@NotNull DataOutput out, Long value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/execution/testDiscovery/TestDiscoveryIndex$MethodQNameSerializer", "save"));
            }
            out.writeLong(value);
        }

        public Long read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/execution/testDiscovery/TestDiscoveryIndex$MethodQNameSerializer", "read"));
            }
            return in.readLong();
        }

        public int getHashCode(Long value) {
            return value.hashCode();
        }

        public boolean isEqual(Long val1, Long val2) {
            return val1.equals(val2);
        }
    }

    private final class Holder {
        final PersistentHashMap<Long, TIntArrayList> myMethodQNameToTestNames;
        final PersistentHashMap<Integer, TIntObjectHashMap<TIntArrayList>> myTestNameToUsedClassesAndMethodMap;
        final PersistentStringEnumerator myClassEnumerator;
        final CachingEnumerator<String> myClassEnumeratorCache;
        final PersistentStringEnumerator myMethodEnumerator;
        final CachingEnumerator<String> myMethodEnumeratorCache;
        final PersistentStringEnumerator myTestNameEnumerator;
        final List<PersistentEnumeratorDelegate> myConstructedDataFiles = new ArrayList<PersistentEnumeratorDelegate>(4);
        private ScheduledFuture<?> myFlushingFuture;
        private boolean myDisposed;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Holder() {
            String path = TestDiscoveryExtension.baseTestDiscoveryPathForProject(TestDiscoveryIndex.this.myProject);
            File versionFile = TestDiscoveryIndex.getVersionFile(path);
            versionFile.getParentFile().mkdirs();
            File methodQNameToTestNameFile = new File(path + File.separator + "methodQNameToTestName.data");
            File testNameToUsedClassesAndMethodMapFile = new File(path + File.separator + "testToCalledMethodNames.data");
            File classNameEnumeratorFile = new File(path + File.separator + "classNameEnumerator.data");
            File methodNameEnumeratorFile = new File(path + File.separator + "methodNameEnumerator.data");
            File testNameEnumeratorFile = new File(path + File.separator + "testNameEnumerator.data");
            try {
                PersistentStringEnumerator testNameEnumerator;
                PersistentStringEnumerator methodNameEnumerator;
                PersistentStringEnumerator classNameEnumerator;
                PersistentHashMap testNameToUsedClassesAndMethodMap;
                PersistentHashMap methodQNameToTestNames;
                int version = this.readVersion(versionFile);
                if (version != 2) {
                    LOG.info("TestDiscoveryIndex was rewritten due to version change");
                    this.deleteAllIndexDataFiles(methodQNameToTestNameFile, testNameToUsedClassesAndMethodMapFile, classNameEnumeratorFile, methodNameEnumeratorFile, testNameEnumeratorFile);
                    this.writeVersion(versionFile);
                }
                int iterations = 0;
                while (true) {
                    ++iterations;
                    try {
                        methodQNameToTestNames = new PersistentHashMap(methodQNameToTestNameFile, (KeyDescriptor)new MethodQNameSerializer(), (DataExternalizer)new TestNamesExternalizer());
                        this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)methodQNameToTestNames);
                        testNameToUsedClassesAndMethodMap = new PersistentHashMap(testNameToUsedClassesAndMethodMapFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new ClassesAndMethodsMapDataExternalizer());
                        this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)testNameToUsedClassesAndMethodMap);
                        classNameEnumerator = new PersistentStringEnumerator(classNameEnumeratorFile);
                        this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)classNameEnumerator);
                        methodNameEnumerator = new PersistentStringEnumerator(methodNameEnumeratorFile);
                        this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)methodNameEnumerator);
                        testNameEnumerator = new PersistentStringEnumerator(testNameEnumeratorFile);
                        this.myConstructedDataFiles.add((PersistentEnumeratorDelegate)testNameEnumerator);
                    }
                    catch (Throwable throwable) {
                        LOG.info("TestDiscoveryIndex problem", throwable);
                        this.closeAllConstructedFiles(true);
                        this.myConstructedDataFiles.clear();
                        this.deleteAllIndexDataFiles(methodQNameToTestNameFile, testNameToUsedClassesAndMethodMapFile, classNameEnumeratorFile, methodNameEnumeratorFile, testNameEnumeratorFile);
                        if (iterations < 3) continue;
                        LOG.error("Unexpected circular initialization problem");
                        assert (false);
                        continue;
                    }
                    break;
                }
                this.myMethodQNameToTestNames = methodQNameToTestNames;
                this.myTestNameToUsedClassesAndMethodMap = testNameToUsedClassesAndMethodMap;
                this.myClassEnumerator = classNameEnumerator;
                this.myMethodEnumerator = methodNameEnumerator;
                this.myTestNameEnumerator = testNameEnumerator;
                this.myMethodEnumeratorCache = new CachingEnumerator((DataEnumerator)methodNameEnumerator, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE);
                this.myClassEnumeratorCache = new CachingEnumerator((DataEnumerator)classNameEnumerator, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE);
                this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = TestDiscoveryIndex.this.ourLock;
                        synchronized (object) {
                            if (Holder.this.myDisposed) {
                                Holder.this.myFlushingFuture.cancel(false);
                                return;
                            }
                            for (PersistentEnumeratorDelegate dataFile : Holder.this.myConstructedDataFiles) {
                                if (!dataFile.isDirty()) continue;
                                dataFile.force();
                            }
                            Holder.this.myClassEnumeratorCache.clear();
                            Holder.this.myMethodEnumeratorCache.clear();
                        }
                    }
                });
                return;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private void closeAllConstructedFiles(boolean ignoreCloseProblem) {
            for (Closeable closeable : this.myConstructedDataFiles) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {
                    if (ignoreCloseProblem) continue;
                    throw new RuntimeException(throwable);
                }
            }
        }

        private void deleteAllIndexDataFiles(File methodQNameToTestNameFile, File testNameToUsedClassesAndMethodMapFile, File classNameEnumeratorFile, File methodNameEnumeratorFile, File testNameEnumeratorFile) {
            IOUtil.deleteAllFilesStartingWith((File)methodQNameToTestNameFile);
            IOUtil.deleteAllFilesStartingWith((File)testNameToUsedClassesAndMethodMapFile);
            IOUtil.deleteAllFilesStartingWith((File)classNameEnumeratorFile);
            IOUtil.deleteAllFilesStartingWith((File)methodNameEnumeratorFile);
            IOUtil.deleteAllFilesStartingWith((File)testNameEnumeratorFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeVersion(File versionFile) throws IOException {
            DataOutputStream versionOut = new DataOutputStream(new FileOutputStream(versionFile));
            try {
                DataInputOutputUtil.writeINT((DataOutput)versionOut, (int)2);
            }
            finally {
                try {
                    versionOut.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readVersion(File versionFile) throws IOException {
            int version;
            if (!versionFile.exists()) {
                return 0;
            }
            DataInputStream versionInput = new DataInputStream(new FileInputStream(versionFile));
            try {
                version = DataInputOutputUtil.readINT((DataInput)versionInput);
            }
            finally {
                try {
                    versionInput.close();
                }
                catch (IOException iOException) {}
            }
            return version;
        }

        void dispose() {
            assert (Thread.holdsLock(TestDiscoveryIndex.this.ourLock));
            try {
                this.closeAllConstructedFiles(false);
            }
            finally {
                this.myDisposed = true;
            }
        }

        private class ClassesAndMethodsMapDataExternalizer
        implements DataExternalizer<TIntObjectHashMap<TIntArrayList>> {
            private ClassesAndMethodsMapDataExternalizer() {
            }

            public void save(@NotNull DataOutput dataOutput, TIntObjectHashMap<TIntArrayList> classAndMethodsMap) throws IOException {
                if (dataOutput == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataOutput", "com/intellij/execution/testDiscovery/TestDiscoveryIndex$Holder$ClassesAndMethodsMapDataExternalizer", "save"));
                }
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)classAndMethodsMap.size());
                int[] classNameIds = classAndMethodsMap.keys();
                Arrays.sort(classNameIds);
                int prevClassNameId = 0;
                for (int classNameId : classNameIds) {
                    DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)(classNameId - prevClassNameId));
                    TIntArrayList value = (TIntArrayList)classAndMethodsMap.get(classNameId);
                    DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)value.size());
                    int[] methodNameIds = value.toNativeArray();
                    Arrays.sort(methodNameIds);
                    int prevMethodNameId = 0;
                    for (int methodNameId : methodNameIds) {
                        DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)(methodNameId - prevMethodNameId));
                        prevMethodNameId = methodNameId;
                    }
                    prevClassNameId = classNameId;
                }
            }

            public TIntObjectHashMap<TIntArrayList> read(@NotNull DataInput dataInput) throws IOException {
                if (dataInput == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataInput", "com/intellij/execution/testDiscovery/TestDiscoveryIndex$Holder$ClassesAndMethodsMapDataExternalizer", "read"));
                }
                int numberOfClasses = DataInputOutputUtil.readINT((DataInput)dataInput);
                TIntObjectHashMap result2 = new TIntObjectHashMap();
                int prevClassNameId = 0;
                while (numberOfClasses-- > 0) {
                    int classNameId = DataInputOutputUtil.readINT((DataInput)dataInput) + prevClassNameId;
                    int numberOfMethods = DataInputOutputUtil.readINT((DataInput)dataInput);
                    TIntArrayList methodNameIds = new TIntArrayList(numberOfMethods);
                    int prevMethodNameId = 0;
                    while (numberOfMethods-- > 0) {
                        int methodNameId = DataInputOutputUtil.readINT((DataInput)dataInput) + prevMethodNameId;
                        methodNameIds.add(methodNameId);
                        prevMethodNameId = methodNameId;
                    }
                    result2.put(classNameId, (Object)methodNameIds);
                    prevClassNameId = classNameId;
                }
                return result2;
            }
        }

        private class TestNamesExternalizer
        implements DataExternalizer<TIntArrayList> {
            private TestNamesExternalizer() {
            }

            public void save(@NotNull DataOutput dataOutput, TIntArrayList testNameIds) throws IOException {
                if (dataOutput == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataOutput", "com/intellij/execution/testDiscovery/TestDiscoveryIndex$Holder$TestNamesExternalizer", "save"));
                }
                for (int testNameId : testNameIds.toNativeArray()) {
                    DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId);
                }
            }

            public TIntArrayList read(@NotNull DataInput dataInput) throws IOException {
                if (dataInput == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataInput", "com/intellij/execution/testDiscovery/TestDiscoveryIndex$Holder$TestNamesExternalizer", "read"));
                }
                TIntHashSet result2 = new TIntHashSet();
                while (((InputStream)((Object)dataInput)).available() > 0) {
                    int id = DataInputOutputUtil.readINT((DataInput)dataInput);
                    if (-1 == id) {
                        id = DataInputOutputUtil.readINT((DataInput)dataInput);
                        result2.remove(id);
                        continue;
                    }
                    result2.add(id);
                }
                return new TIntArrayList(result2.toArray());
            }
        }
    }
}

