/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultFacetsProvider
implements FacetsProvider {
    public static final FacetsProvider INSTANCE = new DefaultFacetsProvider();

    @NotNull
    public Facet[] getAllFacets(Module module) {
        Facet[] facetArray = FacetManager.getInstance((Module)module).getAllFacets();
        if (facetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/DefaultFacetsProvider", "getAllFacets"));
        }
        return facetArray;
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(Module module, FacetTypeId<F> type) {
        Collection collection = FacetManager.getInstance((Module)module).getFacetsByType(type);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/DefaultFacetsProvider", "getFacetsByType"));
        }
        return collection;
    }

    @Nullable
    public <F extends Facet> F findFacet(Module module, FacetTypeId<F> type, String name) {
        return (F)FacetManager.getInstance((Module)module).findFacet(type, name);
    }
}

