/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FindInProjectTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindInProjectTask");
    private static final int FILES_SIZE_LIMIT = 0x4600000;
    private static final int SINGLE_FILE_SIZE_LIMIT = 0x500000;
    private final FindModel myFindModel;
    private final Project myProject;
    private final PsiManager myPsiManager;
    @Nullable
    private final VirtualFile myDirectory;
    private final ProjectFileIndex myProjectFileIndex;
    private final FileIndex myFileIndex;
    private final Condition<VirtualFile> myFileMask;
    private final ProgressIndicator myProgress;
    @Nullable
    private final Module myModule;
    private final Set<VirtualFile> myLargeFiles;
    private boolean myWarningShown;

    FindInProjectTask(@NotNull FindModel findModel, final @NotNull Project project) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectTask", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectTask", "<init>"));
        }
        this.myLargeFiles = ContainerUtil.newTroveSet();
        this.myFindModel = findModel;
        this.myProject = project;
        this.myDirectory = FindInProjectUtil.getDirectory(findModel);
        this.myPsiManager = PsiManager.getInstance((Project)project);
        final String moduleName = findModel.getModuleName();
        this.myModule = moduleName == null ? null : (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            public Module compute() {
                return ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
            }
        });
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myFileIndex = this.myModule == null ? this.myProjectFileIndex : ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
        String filter = findModel.getFileFilter();
        final Pattern pattern = FindInProjectUtil.createFileMaskRegExp(filter);
        this.myFileMask = pattern == null ? Conditions.alwaysTrue() : new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return file != null && pattern.matcher(file.getName()).matches();
            }
        };
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        this.myProgress = progress != null ? progress : new EmptyProgressIndicator();
    }

    public void findUsages(@NotNull Processor<UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        block9: {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectTask", "findUsages"));
            }
            if (processPresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectTask", "findUsages"));
            }
            try {
                this.myProgress.setIndeterminate(true);
                this.myProgress.setText("Scanning indexed files...");
                Set filesForFastWordSearch = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<VirtualFile>>(){

                    public Set<VirtualFile> compute() {
                        return FindInProjectTask.this.getFilesForFastWordSearch();
                    }
                });
                this.myProgress.setIndeterminate(false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for " + this.myFindModel.getStringToFind() + " in " + filesForFastWordSearch.size() + " indexed files");
                }
                this.searchInFiles(filesForFastWordSearch, processPresentation, consumer);
                this.myProgress.setIndeterminate(true);
                this.myProgress.setText("Scanning non-indexed files...");
                boolean skipIndexed = this.canRelyOnIndices();
                Collection<VirtualFile> otherFiles = this.collectFilesInScope(filesForFastWordSearch, skipIndexed);
                this.myProgress.setIndeterminate(false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for " + this.myFindModel.getStringToFind() + " in " + otherFiles.size() + " non-indexed files");
                }
                long start = System.currentTimeMillis();
                this.searchInFiles(otherFiles, processPresentation, consumer);
                if (skipIndexed && otherFiles.size() > 1000) {
                    FindInProjectTask.logStats(otherFiles, start);
                }
            }
            catch (ProcessCanceledException e) {
                processPresentation.setCanceled(true);
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug("Usage search canceled", (Throwable)e);
            }
        }
        if (!this.myLargeFiles.isEmpty()) {
            processPresentation.setLargeFilesWereNotScanned(this.myLargeFiles);
        }
        if (!this.myProgress.isCanceled()) {
            this.myProgress.setText(FindBundle.message("find.progress.search.completed", new Object[0]));
        }
    }

    private static void logStats(Collection<VirtualFile> otherFiles, long start) {
        long time = System.currentTimeMillis() - start;
        HashMultiset stats = HashMultiset.create();
        for (VirtualFile file : otherFiles) {
            stats.add((Object)StringUtil.notNullize((String)file.getExtension()).toLowerCase());
        }
        ArrayList extensions = ContainerUtil.newArrayList((Iterable)stats.elementSet());
        Collections.sort(extensions, new Comparator<String>((Multiset)stats){
            final /* synthetic */ Multiset val$stats;
            {
                this.val$stats = multiset;
            }

            @Override
            public int compare(String o1, String o2) {
                return this.val$stats.count((Object)o2) - this.val$stats.count((Object)o1);
            }
        });
        String message = "Search in " + otherFiles.size() + " files with unknown types took " + time + "ms.\n" + "Mapping their extensions to an existing file type (e.g. Plain Text) might speed up the search.\n" + "Most frequent non-indexed file extensions: ";
        for (int i = 0; i < Math.min(10, extensions.size()); ++i) {
            String extension = (String)extensions.get(i);
            message = message + extension + "(" + stats.count((Object)extension) + ") ";
        }
        LOG.info(message);
    }

    private void searchInFiles(@NotNull Collection<VirtualFile> virtualFiles, @NotNull FindUsagesProcessPresentation processPresentation, final @NotNull Processor<UsageInfo> consumer) {
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/find/impl/FindInProjectTask", "searchInFiles"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectTask", "searchInFiles"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectTask", "searchInFiles"));
        }
        int i = 0;
        long totalFilesSize = 0L;
        int count = 0;
        for (final VirtualFile virtualFile : virtualFiles) {
            boolean skipProjectFile;
            long fileLength;
            int index = i++;
            if (!virtualFile.isValid() || (fileLength = UsageViewManagerImpl.getFileLength((VirtualFile)virtualFile)) == -1L) continue;
            boolean bl = skipProjectFile = ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) && !this.myFindModel.isSearchInProjectFiles();
            if (skipProjectFile && !Registry.is((String)"find.search.in.project.files")) continue;
            if (fileLength > 0x500000L) {
                this.myLargeFiles.add(virtualFile);
                continue;
            }
            this.myProgress.checkCanceled();
            this.myProgress.setFraction((double)index / (double)virtualFiles.size());
            String text = FindBundle.message("find.searching.for.string.in.file.progress", this.myFindModel.getStringToFind(), virtualFile.getPresentableUrl());
            this.myProgress.setText(text);
            this.myProgress.setText2(FindBundle.message("find.searching.for.string.in.file.occurrences.progress", count));
            PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                public PsiFile compute() {
                    return FindInProjectTask.this.findFile(virtualFile);
                }
            });
            if (psiFile == null) continue;
            int countInFile = FindInProjectUtil.processUsagesInFile(psiFile, this.myFindModel, new Processor<UsageInfo>(){

                public boolean process(UsageInfo info) {
                    return skipProjectFile || consumer.process((Object)info);
                }
            });
            if (countInFile > 0 && skipProjectFile) {
                processPresentation.projectFileUsagesFound(new Runnable(){

                    @Override
                    public void run() {
                        FindModel model = FindInProjectTask.this.myFindModel.clone();
                        model.setSearchInProjectFiles(true);
                        FindInProjectManager.getInstance(FindInProjectTask.this.myProject).startFindInProject(model);
                    }
                });
                continue;
            }
            count += countInFile;
            if (countInFile <= 0 || (totalFilesSize += fileLength) <= 0x4600000L || this.myWarningShown) continue;
            this.myWarningShown = true;
            String message = FindBundle.message("find.excessive.total.size.prompt", UsageViewManagerImpl.presentableSize((long)totalFilesSize), ApplicationNamesInfo.getInstance().getProductName());
            UsageLimitUtil.showAndCancelIfAborted((Project)this.myProject, (String)message, (UsageViewPresentation)processPresentation.getUsageViewPresentation());
        }
    }

    @NotNull
    private Collection<VirtualFile> collectFilesInScope(final @NotNull Set<VirtualFile> alreadySearched, final boolean skipIndexed) {
        if (alreadySearched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadySearched", "com/intellij/find/impl/FindInProjectTask", "collectFilesInScope"));
        }
        SearchScope customScope = this.myFindModel.isCustomScope() ? this.myFindModel.getCustomScope() : null;
        final GlobalSearchScope globalCustomScope = customScope == null ? null : this.toGlobal(customScope);
        final ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        final boolean hasTrigrams = FindInProjectTask.hasTrigrams(this.myFindModel.getStringToFind());
        class EnumContentIterator
        implements ContentIterator {
            private final Set<VirtualFile> myFiles = new LinkedHashSet<VirtualFile>();

            EnumContentIterator() {
            }

            public boolean processFile(final @NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/find/impl/FindInProjectTask$1EnumContentIterator", "processFile"));
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){
                    private final FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();

                    @Override
                    public void run() {
                        ProgressManager.checkCanceled();
                        if (virtualFile.isDirectory() || !virtualFile.isValid() || !FindInProjectTask.this.myFileMask.value((Object)virtualFile) || globalCustomScope != null && !globalCustomScope.contains(virtualFile)) {
                            return;
                        }
                        if (skipIndexed && this.isCoveredByIndex(virtualFile) && (fileIndex.isInContent(virtualFile) || fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInLibrarySource(virtualFile))) {
                            return;
                        }
                        PsiFile psiFile = FindInProjectTask.this.findFile(virtualFile);
                        VirtualFile sourceVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
                        if (sourceVirtualFile != null && !alreadySearched.contains(sourceVirtualFile)) {
                            myFiles.add(sourceVirtualFile);
                        }
                    }

                    private boolean isCoveredByIndex(VirtualFile file) {
                        FileType fileType = file.getFileType();
                        if (hasTrigrams) {
                            return TrigramIndex.isIndexable(fileType) && this.fileBasedIndex.isIndexingCandidate(file, TrigramIndex.INDEX_ID);
                        }
                        return IdIndex.isIndexable(fileType) && this.fileBasedIndex.isIndexingCandidate(file, IdIndex.NAME);
                    }
                });
                return true;
            }

            @NotNull
            private Collection<VirtualFile> getFiles() {
                Set<VirtualFile> set = this.myFiles;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask$1EnumContentIterator", "getFiles"));
                }
                return set;
            }
        }
        final EnumContentIterator iterator = new EnumContentIterator();
        if (customScope instanceof LocalSearchScope) {
            for (VirtualFile file : FindInProjectTask.getLocalScopeFiles((LocalSearchScope)customScope)) {
                iterator.processFile(file);
            }
        } else if (customScope instanceof Iterable) {
            for (VirtualFile file : (Iterable)customScope) {
                iterator.processFile(file);
            }
        } else if (this.myDirectory != null) {
            final boolean checkExcluded = !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isExcluded(this.myDirectory);
            VirtualFileVisitor.Option limit = VirtualFileVisitor.limit((int)(this.myFindModel.isWithSubdirectories() ? -1 : 1));
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myDirectory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{limit}){
                {
                    super(arg0);
                }

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindInProjectTask$8", "visitFile"));
                    }
                    if (checkExcluded && FindInProjectTask.this.myProjectFileIndex.isExcluded(file)) {
                        return false;
                    }
                    iterator.processFile(file);
                    return true;
                }
            });
        } else {
            boolean success = this.myFileIndex.iterateContent((ContentIterator)iterator);
            if (success && globalCustomScope != null && globalCustomScope.isSearchInLibraries()) {
                VirtualFile[] librarySources = (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

                    public VirtualFile[] compute() {
                        OrderEnumerator enumerator = FindInProjectTask.this.myModule == null ? OrderEnumerator.orderEntries((Project)FindInProjectTask.this.myProject) : OrderEnumerator.orderEntries((Module)FindInProjectTask.this.myModule);
                        return enumerator.withoutModuleSourceEntries().withoutDepModules().getSourceRoots();
                    }
                });
                FindInProjectTask.iterateAll(librarySources, globalCustomScope, iterator);
            }
        }
        Collection collection = iterator.getFiles();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "collectFilesInScope"));
        }
        return collection;
    }

    private static boolean iterateAll(@NotNull VirtualFile[] files, final @NotNull GlobalSearchScope searchScope, @NotNull ContentIterator iterator) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VirtualFileFilter contentFilter = new VirtualFileFilter(){

            public boolean accept(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindInProjectTask$10", "accept"));
                }
                return file.isDirectory() || !fileTypeManager.isFileIgnored(file) && !file.getFileType().isBinary() && searchScope.contains(file);
            }
        };
        for (VirtualFile file : files) {
            if (VfsUtilCore.iterateChildrenRecursively((VirtualFile)file, (VirtualFileFilter)contentFilter, (ContentIterator)iterator)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private GlobalSearchScope toGlobal(final @NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/find/impl/FindInProjectTask", "toGlobal"));
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "toGlobal"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<GlobalSearchScope>(){

            public GlobalSearchScope compute() {
                return GlobalSearchScope.filesScope((Project)FindInProjectTask.this.myProject, (Collection)FindInProjectTask.getLocalScopeFiles((LocalSearchScope)scope));
            }
        });
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "toGlobal"));
        }
        return globalSearchScope;
    }

    @NotNull
    private static Set<VirtualFile> getLocalScopeFiles(final @NotNull LocalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/find/impl/FindInProjectTask", "getLocalScopeFiles"));
        }
        Set set = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<VirtualFile>>(){

            public Set<VirtualFile> compute() {
                LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
                for (PsiElement element : scope.getScope()) {
                    PsiFile file = element.getContainingFile();
                    if (file == null) continue;
                    ContainerUtil.addIfNotNull(files, (Object)file.getVirtualFile());
                    ContainerUtil.addIfNotNull(files, (Object)file.getNavigationElement().getContainingFile().getVirtualFile());
                }
                return files;
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getLocalScopeFiles"));
        }
        return set;
    }

    private boolean canRelyOnIndices() {
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        if (this.myFindModel.isRegularExpressions()) {
            return false;
        }
        if (this.myFindModel.getCustomScope() instanceof LocalSearchScope) {
            return false;
        }
        String text = this.myFindModel.getStringToFind();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return false;
        }
        if (FindInProjectTask.hasTrigrams(text)) {
            return true;
        }
        return this.myFindModel.isWholeWordsOnly() && text.indexOf(36) < 0 && !StringUtil.getWordsInStringLongestFirst((String)text).isEmpty();
    }

    private static boolean hasTrigrams(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/impl/FindInProjectTask", "hasTrigrams"));
        }
        return TrigramIndex.ENABLED && !TrigramBuilder.processTrigrams((CharSequence)text, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor(){

            public boolean execute(int value) {
                return false;
            }
        });
    }

    @NotNull
    private Set<VirtualFile> getFilesForFastWordSearch() {
        VirtualFile[] filesWithWord;
        String stringToFind = this.myFindModel.getStringToFind();
        if (stringToFind.isEmpty() || DumbService.getInstance((Project)this.myProject).isDumb() || this.myFindModel.isRegularExpressions()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
            }
            return set;
        }
        GlobalSearchScope scope = this.toGlobal(FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel));
        final LinkedHashSet<VirtualFile> resultFiles = new LinkedHashSet<VirtualFile>();
        if (TrigramIndex.ENABLED) {
            THashSet keys = ContainerUtil.newTroveSet();
            TrigramBuilder.processTrigrams((CharSequence)stringToFind, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor((Set)keys){
                final /* synthetic */ Set val$keys;
                {
                    this.val$keys = set;
                }

                public boolean execute(int value) {
                    this.val$keys.add(value);
                    return true;
                }
            });
            if (!keys.isEmpty()) {
                ArrayList hits = new ArrayList();
                ApplicationManager.getApplication().runReadAction(new Runnable((Set)keys, hits, scope){
                    final /* synthetic */ Set val$keys;
                    final /* synthetic */ List val$hits;
                    final /* synthetic */ GlobalSearchScope val$scope;
                    {
                        this.val$keys = set;
                        this.val$hits = list;
                        this.val$scope = globalSearchScope;
                    }

                    @Override
                    public void run() {
                        FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, this.val$keys, (Processor)new CommonProcessors.CollectProcessor((Collection)this.val$hits), this.val$scope);
                    }
                });
                for (VirtualFile hit : hits) {
                    if (!this.myFileMask.value((Object)hit)) continue;
                    resultFiles.add(hit);
                }
                LinkedHashSet<VirtualFile> linkedHashSet = resultFiles;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
                }
                return linkedHashSet;
            }
        }
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)this.myProject);
        helper.processFilesWithText(scope, (short)255, this.myFindModel.isCaseSensitive(), stringToFind, new Processor<VirtualFile>(){

            public boolean process(VirtualFile file) {
                if (FindInProjectTask.this.myFileMask.value((Object)file)) {
                    ContainerUtil.addIfNotNull((Collection)resultFiles, (Object)file);
                }
                return true;
            }
        });
        CacheManager cacheManager = CacheManager.SERVICE.getInstance(this.myProject);
        for (VirtualFile file : filesWithWord = cacheManager.getVirtualFilesWithWord(stringToFind, (short)255, scope, this.myFindModel.isCaseSensitive())) {
            if (!this.myFileMask.value((Object)file)) continue;
            resultFiles.add(file);
        }
        LinkedHashSet<VirtualFile> linkedHashSet = resultFiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
        }
        return linkedHashSet;
    }

    private PsiFile findFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/find/impl/FindInProjectTask", "findFile"));
        }
        PsiFile psiFile = this.myPsiManager.findFile(virtualFile);
        if (psiFile != null && !(psiFile instanceof PsiBinaryFile)) {
            PsiFile sourceFile = (PsiFile)psiFile.getNavigationElement();
            if (sourceFile != null) {
                psiFile = sourceFile;
            }
            if (psiFile.getFileType().isBinary()) {
                psiFile = null;
            }
        }
        return psiFile;
    }
}

