/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FormatTextRanges {
    private final List<FormatTextRange> myRanges = new ArrayList<FormatTextRange>();

    public FormatTextRanges() {
    }

    public FormatTextRanges(TextRange range, boolean processHeadingWhitespace) {
        this.add(range, processHeadingWhitespace);
    }

    public void add(TextRange range, boolean processHeadingWhitespace) {
        this.myRanges.add(new FormatTextRange(range, processHeadingWhitespace));
    }

    public boolean isWhitespaceReadOnly(TextRange range) {
        for (FormatTextRange formatTextRange : this.myRanges) {
            if (formatTextRange.isWhitespaceReadOnly(range)) continue;
            return false;
        }
        return true;
    }

    public boolean isReadOnly(TextRange range, boolean rootIsRightBlock) {
        for (FormatTextRange formatTextRange : this.myRanges) {
            if (formatTextRange.isReadOnly(range, rootIsRightBlock)) continue;
            return false;
        }
        return true;
    }

    public List<FormatTextRange> getRanges() {
        return this.myRanges;
    }

    public FormatTextRanges ensureNonEmpty() {
        FormatTextRanges result2 = new FormatTextRanges();
        for (FormatTextRange range : this.myRanges) {
            if (range.myProcessHeadingWhitespace) {
                result2.add(range.getNonEmptyTextRange(), true);
                continue;
            }
            result2.add(range.getTextRange(), false);
        }
        return result2;
    }

    public String toString() {
        return "FormatTextRanges{" + StringUtil.join(this.myRanges, (Function)StringUtil.createToStringFunction(FormatTextRange.class), (String)",");
    }

    public static class FormatTextRange {
        private TextRange myRange;
        private final boolean myProcessHeadingWhitespace;

        public FormatTextRange(TextRange range, boolean processHeadingWhitespace) {
            this.myRange = range;
            this.myProcessHeadingWhitespace = processHeadingWhitespace;
        }

        public boolean isWhitespaceReadOnly(@Nullable TextRange range) {
            if (this.myRange == null) {
                return false;
            }
            if (range == null || range.getStartOffset() >= this.myRange.getEndOffset()) {
                return true;
            }
            if (this.myProcessHeadingWhitespace) {
                return range.getEndOffset() < this.myRange.getStartOffset();
            }
            return range.getEndOffset() <= this.myRange.getStartOffset();
        }

        public int getStartOffset() {
            return this.myRange.getStartOffset();
        }

        public boolean isReadOnly(TextRange range, boolean rootIsRightBlock) {
            if (this.myRange == null || this.myRange.getStartOffset() >= range.getEndOffset() && rootIsRightBlock) {
                return false;
            }
            return range.getStartOffset() > this.myRange.getEndOffset() || range.getEndOffset() < this.myRange.getStartOffset();
        }

        public TextRange getTextRange() {
            return this.myRange;
        }

        public void setTextRange(TextRange range) {
            this.myRange = range;
        }

        public TextRange getNonEmptyTextRange() {
            return new TextRange(this.myRange.getStartOffset(), this.myRange.getStartOffset() == this.myRange.getEndOffset() ? this.myRange.getEndOffset() + 1 : this.myRange.getEndOffset());
        }

        public String toString() {
            return this.myRange.toString() + (this.myProcessHeadingWhitespace ? "+" : "");
        }
    }
}

