/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileIconPatcher;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntheticElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class JavaFileIconPatcher
implements FileIconPatcher {
    public Icon patchIcon(Icon baseIcon, VirtualFile file, int flags, Project project) {
        if (project == null) {
            return baseIcon;
        }
        Icon icon = JavaFileIconPatcher.replaceIcon(file, flags, project, baseIcon);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isInSource(file) && CompilerManager.getInstance((Project)project).isExcludedFromCompilation(file)) {
            return new LayeredIcon(new Icon[]{icon, PlatformIcons.EXCLUDED_FROM_COMPILE_ICON});
        }
        return icon;
    }

    private static Icon replaceIcon(VirtualFile file, @Iconable.IconFlags int flags, Project project, Icon baseIcon) {
        PsiClass[] classes;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA && !FileIndexUtil.isJavaSourceFile((Project)project, (VirtualFile)file)) {
            return PlatformIcons.JAVA_OUTSIDE_SOURCE_ICON;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof PsiClassOwner && psiFile.getViewProvider().getBaseLanguage() == StdLanguages.JAVA && (classes = ((PsiClassOwner)psiFile).getClasses()).length > 0) {
            String fileName = file.getNameWithoutExtension();
            for (PsiClass aClass : classes) {
                if (aClass instanceof SyntheticElement) {
                    return baseIcon;
                }
                if (!Comparing.strEqual((String)aClass.getName(), (String)fileName)) continue;
                return aClass.getIcon(flags);
            }
            return classes[classes.length - 1].getIcon(flags);
        }
        return baseIcon;
    }
}

