/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChooseComponentsToExportDialog;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0005\u00031\u0001\u0011$\u0001M\u00013\u0005A\u0012!)\u0002R\u0007\u0005A\u0019!J\u0005\u0005\u0017!\u0011Q\"\u0001M\u00033\u0011A1!\u0004\u0002\r\u0002a\u001d\u0001"}, strings={"Lcom/intellij/ide/actions/ExportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;"}, moduleName="configuration-store-impl")
public final class ExportSettingsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@Nullable AnActionEvent e) {
        ApplicationManager.getApplication().saveSettings();
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(ExportSettingsActionKt.getExportableComponentsMap$default(true, true, null, null, 12), true, IdeBundle.message((String)"title.select.components.to.export", (Object[])new Object[0]), IdeBundle.message((String)"prompt.please.check.all.components.to.export", (Object[])new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        Set<ExportableItem> markedComponents = dialog.getExportableComponents();
        if (markedComponents.isEmpty()) {
            return;
        }
        THashSet exportFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (ExportableItem markedComponent : markedComponents) {
            exportFiles.addAll((Collection)markedComponent.getFiles());
        }
        File saveFile = dialog.getExportFile();
        try {
            if (saveFile.exists() && Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.overwrite.settings.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)saveFile.getPath())}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            Set set = (Set)exportFiles;
            OutputStream outputStream = ByteStreamsKt.buffered$default((OutputStream)FilesKt.outputStream((File)saveFile), (int)0, (int)1);
            String string = FileUtilRt.toSystemIndependentName((String)PathManager.getConfigPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.toSystemIndep\u2026hManager.getConfigPath())");
            ExportSettingsActionKt.exportSettings(set, outputStream, string);
            ShowFilePathAction.showDialog(AnAction.getEventProject((AnActionEvent)e), IdeBundle.message((String)"message.settings.exported.successfully", (Object[])new Object[0]), IdeBundle.message((String)"title.export.successful", (Object[])new Object[0]), saveFile, null);
        }
        catch (IOException e1) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.writing.settings", (Object[])new Object[]{e1.toString()}), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }
}

