/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OpenProjectFileChooserDescriptor
extends FileChooserDescriptor {
    private static final Icon ourProjectIcon = PlatformUtils.isJetBrainsProduct() ? AllIcons.Nodes.IdeaProject : IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl());
    private static final boolean ourCanInspectDirs = SystemProperties.getBooleanProperty((String)"idea.chooser.lookup.for.project.dirs", (boolean)true);

    public OpenProjectFileChooserDescriptor(boolean chooseFiles) {
        super(chooseFiles, true, chooseFiles, chooseFiles, false, false);
        this.setHideIgnored(false);
    }

    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || OpenProjectFileChooserDescriptor.isProjectFile(file));
    }

    public boolean isFileSelectable(VirtualFile file) {
        return OpenProjectFileChooserDescriptor.isProjectDirectory(file) || OpenProjectFileChooserDescriptor.isProjectFile(file);
    }

    public Icon getIcon(VirtualFile file) {
        if (OpenProjectFileChooserDescriptor.canInspectDirectory(file)) {
            if (OpenProjectFileChooserDescriptor.isIprFile(file) || OpenProjectFileChooserDescriptor.isIdeaDirectory(file)) {
                return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file, (Icon)ourProjectIcon);
            }
            Icon icon = OpenProjectFileChooserDescriptor.getImporterIcon(file);
            if (icon != null) {
                return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file, (Icon)icon);
            }
        }
        return super.getIcon(file);
    }

    private static boolean canInspectDirectory(VirtualFile file) {
        VirtualFile home = VfsUtil.getUserHomeDir();
        if (home == null || VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)home, (boolean)false)) {
            return false;
        }
        return ourCanInspectDirs || VfsUtilCore.isAncestor((VirtualFile)home, (VirtualFile)file, (boolean)true);
    }

    private static Icon getImporterIcon(VirtualFile file) {
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)file);
        if (provider != null) {
            return file.isDirectory() && provider.lookForProjectsInDirectory() ? ourProjectIcon : provider.getIcon(file);
        }
        return null;
    }

    public static boolean isProjectFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/OpenProjectFileChooserDescriptor", "isProjectFile"));
        }
        return !file.isDirectory() && file.isValid() && (OpenProjectFileChooserDescriptor.isIprFile(file) || OpenProjectFileChooserDescriptor.hasImportProvider(file));
    }

    private static boolean isProjectDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/OpenProjectFileChooserDescriptor", "isProjectDirectory"));
        }
        return file.isDirectory() && file.isValid() && (OpenProjectFileChooserDescriptor.isIdeaDirectory(file) || OpenProjectFileChooserDescriptor.hasImportProvider(file));
    }

    private static boolean isIprFile(VirtualFile file) {
        return "ipr".equalsIgnoreCase(file.getExtension());
    }

    private static boolean isIdeaDirectory(VirtualFile file) {
        return file.findChild(".idea") != null;
    }

    private static boolean hasImportProvider(VirtualFile file) {
        return ProjectOpenProcessor.getImportProvider((VirtualFile)file) != null;
    }
}

