/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extensionResources;

import com.intellij.ide.extensionResources.ResourceVersions;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtensionsRootType
extends RootType {
    static final Logger LOG = Logger.getInstance(ExtensionsRootType.class);
    private static final String HASH_ALGORITHM = "MD5";
    private static final String EXTENSIONS_PATH = "extensions";
    private static final String BACKUP_FILE_EXTENSION = "old";

    ExtensionsRootType() {
        super(EXTENSIONS_PATH, "Extensions");
    }

    @NotNull
    public static ExtensionsRootType getInstance() {
        ExtensionsRootType extensionsRootType = ExtensionsRootType.findByClass(ExtensionsRootType.class);
        if (extensionsRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ExtensionsRootType", "getInstance"));
        }
        return extensionsRootType;
    }

    @NotNull
    public static Condition<VirtualFile> regularFileFilter() {
        Condition<VirtualFile> condition = new Condition<VirtualFile>(){
            private final ExtensionsRootType myRootType = ExtensionsRootType.getInstance();

            public boolean value(VirtualFile file) {
                return !file.isDirectory() && !this.myRootType.isBackupFile(file);
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ExtensionsRootType", "regularFileFilter"));
        }
        return condition;
    }

    @Nullable
    public PluginId getOwner(@Nullable VirtualFile resource) {
        VirtualFile file = this.getPluginResourcesDirectoryFor(resource);
        return file != null ? PluginId.findId((String[])new String[]{file.getName()}) : null;
    }

    @Nullable
    public VirtualFile findResource(@NotNull PluginId pluginId, @NotNull String path, boolean createIfMissing) throws IOException {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/extensionResources/ExtensionsRootType", "findResource"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/extensionResources/ExtensionsRootType", "findResource"));
        }
        this.extractBundledExtensionsIfNeeded(pluginId);
        return this.findExtensionImpl(pluginId, path, createIfMissing);
    }

    @Nullable
    public VirtualFile findResourceDirectory(@NotNull PluginId pluginId, @NotNull String path, boolean createIfMissing) throws IOException {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/extensionResources/ExtensionsRootType", "findResourceDirectory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/extensionResources/ExtensionsRootType", "findResourceDirectory"));
        }
        this.extractBundledExtensionsIfNeeded(pluginId);
        return this.findExtensionsDirectoryImpl(pluginId, path, createIfMissing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractBundledResources(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/extensionResources/ExtensionsRootType", "extractBundledResources"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/extensionResources/ExtensionsRootType", "extractBundledResources"));
        }
        List<URL> bundledResources = ExtensionsRootType.getBundledResourceUrls(pluginId, path);
        if (bundledResources.isEmpty()) {
            return;
        }
        VirtualFile resourcesDirectory = this.findExtensionsDirectoryImpl(pluginId, path, true);
        if (resourcesDirectory == null) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        for (URL bundledResourceDirUrl : bundledResources) {
            VirtualFile bundledResourcesDir = VfsUtil.findFileByURL((URL)bundledResourceDirUrl);
            if (!bundledResourcesDir.isDirectory()) continue;
            AccessToken token = application.acquireWriteActionLock(ExtensionsRootType.class);
            try {
                FileDocumentManager.getInstance().saveAllDocuments();
                ExtensionsRootType.extractResources(bundledResourcesDir, resourcesDirectory);
            }
            finally {
                token.finish();
            }
        }
    }

    @Override
    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/extensionResources/ExtensionsRootType", "substituteName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/extensionResources/ExtensionsRootType", "substituteName"));
        }
        try {
            String name;
            VirtualFile resourcesDir = this.getPluginResourcesDirectoryFor(file);
            if (file.equals(resourcesDir) && (name = this.getPluginResourcesRootName(resourcesDir)) != null) {
                return name;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.substituteName(project, file);
    }

    public boolean isBackupFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/extensionResources/ExtensionsRootType", "isBackupFile"));
        }
        String extension = file.getExtension();
        return !file.isDirectory() && extension != null && extension.startsWith(BACKUP_FILE_EXTENSION);
    }

    @Nullable
    String getPath(@Nullable VirtualFile resource) {
        VirtualFile pluginResourcesDir = this.getPluginResourcesDirectoryFor(resource);
        PluginId pluginId = this.getOwner(pluginResourcesDir);
        return pluginResourcesDir != null && pluginId != null ? VfsUtilCore.getRelativePath((VirtualFile)resource, (VirtualFile)pluginResourcesDir) : null;
    }

    @Nullable
    private VirtualFile findExtensionImpl(@NotNull PluginId pluginId, @NotNull String path, boolean createIfMissing) throws IOException {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/extensionResources/ExtensionsRootType", "findExtensionImpl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/extensionResources/ExtensionsRootType", "findExtensionImpl"));
        }
        return this.findFile(null, pluginId.getIdString() + "/" + path, createIfMissing ? ScratchFileService.Option.create_if_missing : ScratchFileService.Option.existing_only);
    }

    @Nullable
    private VirtualFile findExtensionsDirectoryImpl(@NotNull PluginId pluginId, @NotNull String path, boolean createIfMissing) throws IOException {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/extensionResources/ExtensionsRootType", "findExtensionsDirectoryImpl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/extensionResources/ExtensionsRootType", "findExtensionsDirectoryImpl"));
        }
        String resourceDirPath = this.getPath(pluginId, path);
        LocalFileSystem fs = LocalFileSystem.getInstance();
        VirtualFile file = fs.refreshAndFindFileByPath(resourceDirPath);
        if (file == null && createIfMissing) {
            return VfsUtil.createDirectories((String)resourceDirPath);
        }
        return file != null && file.isDirectory() ? file : null;
    }

    @Nullable
    private String getPluginResourcesRootName(VirtualFile resourcesDir) throws IOException {
        PluginId ownerPluginId = this.getOwner(resourcesDir);
        if (ownerPluginId == null) {
            return null;
        }
        if ("com.intellij".equals(ownerPluginId.getIdString())) {
            return PlatformUtils.getPlatformPrefix();
        }
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(ownerPluginId);
        if (plugin != null) {
            return plugin.getName();
        }
        return null;
    }

    @Contract(value="null->null")
    private VirtualFile getPluginResourcesDirectoryFor(@Nullable VirtualFile resource) {
        VirtualFile root;
        VirtualFile virtualFile = root = resource != null ? this.getRootDirectory() : null;
        if (root == null) {
            return null;
        }
        VirtualFile parent = resource;
        VirtualFile file = resource;
        while (parent != null && !root.equals(parent)) {
            file = parent;
            parent = file.getParent();
        }
        return parent != null && file.isDirectory() ? file : null;
    }

    @Nullable
    private VirtualFile getRootDirectory() {
        String path = ScratchFileService.getInstance().getRootPath(this);
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
    }

    @NotNull
    private String getPath(@NotNull PluginId pluginId, @NotNull String path) {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/extensionResources/ExtensionsRootType", "getPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/extensionResources/ExtensionsRootType", "getPath"));
        }
        String string = ScratchFileService.getInstance().getRootPath(this) + "/" + pluginId.getIdString() + (StringUtil.isEmpty((String)path) ? "" : "/" + path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ExtensionsRootType", "getPath"));
        }
        return string;
    }

    @NotNull
    private static List<URL> getBundledResourceUrls(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        Enumeration<URL> urlEnumeration;
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/extensionResources/ExtensionsRootType", "getBundledResourceUrls"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/extensionResources/ExtensionsRootType", "getBundledResourceUrls"));
        }
        String resourcesPath = "extensions/" + path;
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        ClassLoader cl = plugin != null ? plugin.getPluginClassLoader() : null;
        Enumeration<URL> enumeration = urlEnumeration = plugin != null ? cl.getResources(resourcesPath) : null;
        if (urlEnumeration == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ExtensionsRootType", "getBundledResourceUrls"));
            }
            return list;
        }
        PluginId corePluginId = PluginId.findId((String[])new String[]{"com.intellij"});
        HashSet excludedUrls = ContainerUtil.newHashSet();
        if (!plugin.getUseIdeaClassLoader() && !pluginId.equals(corePluginId)) {
            IdeaPluginDescriptor corePlugin = PluginManager.getPlugin(corePluginId);
            ClassLoader ideaClassLoader = ((IdeaPluginDescriptor)ObjectUtils.assertNotNull((Object)corePlugin)).getPluginClassLoader();
            Enumeration<URL> resources = ideaClassLoader.getResources(resourcesPath);
            while (resources.hasMoreElements()) {
                excludedUrls.add(resources.nextElement());
            }
        }
        LinkedHashSet urls = ContainerUtil.newLinkedHashSet();
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            if (excludedUrls.contains(url)) continue;
            urls.add(url);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)urls);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ExtensionsRootType", "getBundledResourceUrls"));
        }
        return arrayList;
    }

    private static void extractResources(@NotNull VirtualFile from, @NotNull VirtualFile to) throws IOException {
        VirtualFile[] fromChildren;
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/ide/extensionResources/ExtensionsRootType", "extractResources"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/ide/extensionResources/ExtensionsRootType", "extractResources"));
        }
        for (VirtualFile fromChild : fromChildren = from.getChildren()) {
            if (fromChild.is(VFileProperty.SYMLINK) || fromChild.is(VFileProperty.SPECIAL)) continue;
            VirtualFile toChild = to.findChild(fromChild.getName());
            if (toChild != null && fromChild.isDirectory() != toChild.isDirectory()) {
                ExtensionsRootType.renameToBackupCopy(toChild);
                toChild = null;
            }
            if (fromChild.isDirectory()) {
                if (toChild == null) {
                    toChild = to.createChildDirectory(ExtensionsRootType.class, fromChild.getName());
                }
                ExtensionsRootType.extractResources(fromChild, toChild);
                continue;
            }
            if (toChild != null) {
                boolean upToDate;
                String fromHash = ExtensionsRootType.hash(fromChild);
                String toHash = ExtensionsRootType.hash(toChild);
                boolean bl = upToDate = fromHash != null && toHash != null && StringUtil.equals((CharSequence)fromHash, (CharSequence)toHash);
                if (upToDate) continue;
                ExtensionsRootType.renameToBackupCopy(toChild);
            }
            toChild = to.createChildData(ExtensionsRootType.class, fromChild.getName());
            toChild.setBinaryContent(fromChild.contentsToByteArray());
        }
    }

    @Nullable
    private static String hash(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/extensionResources/ExtensionsRootType", "hash"));
        }
        try {
            byte[] digest;
            MessageDigest md5 = MessageDigest.getInstance(HASH_ALGORITHM);
            StringBuilder sb = new StringBuilder();
            for (byte b : digest = md5.digest(file.contentsToByteArray())) {
                sb.append(Integer.toHexString(b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Hash algorithm MD5 is not supported." + e);
            return null;
        }
    }

    private static void renameToBackupCopy(@NotNull VirtualFile virtualFile) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/extensionResources/ExtensionsRootType", "renameToBackupCopy"));
        }
        VirtualFile parent = virtualFile.getParent();
        int i = 0;
        String newName = virtualFile.getName() + "." + BACKUP_FILE_EXTENSION;
        while (parent.findChild(newName) != null) {
            newName = virtualFile.getName() + "." + BACKUP_FILE_EXTENSION + "_" + i;
            ++i;
        }
        virtualFile.rename(ExtensionsRootType.class, newName);
    }

    private void extractBundledExtensionsIfNeeded(@NotNull PluginId pluginId) throws IOException {
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/extensionResources/ExtensionsRootType", "extractBundledExtensionsIfNeeded"));
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        if (plugin == null || !ResourceVersions.getInstance().shouldUpdateResourcesOf(plugin)) {
            return;
        }
        this.extractBundledResources(pluginId, "");
        ResourceVersions.getInstance().resourcesUpdated(plugin);
    }
}

