/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.hierarchy.type.TypeHierarchyBrowser;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSyntheticClass;
import org.jetbrains.annotations.NotNull;

public class JavaTypeHierarchyProvider
implements HierarchyProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider");

    public PsiElement getTarget(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider", "getTarget"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("editor " + editor);
        }
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return null;
            }
            PsiElement targetElement = TargetElementUtil.findTargetElement(editor, 11);
            if (LOG.isDebugEnabled()) {
                LOG.debug("target element " + targetElement);
            }
            if (targetElement instanceof PsiClass) {
                return targetElement;
            }
            int offset = editor.getCaretModel().getOffset();
            for (PsiElement element = file.findElementAt(offset); element != null; element = element.getParent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("context element " + element);
                }
                if (element instanceof PsiFile) {
                    if (!(element instanceof PsiClassOwner)) {
                        return null;
                    }
                    PsiClass[] classes = ((PsiClassOwner)element).getClasses();
                    return classes.length == 1 ? classes[0] : null;
                }
                if (!(element instanceof PsiClass) || element instanceof PsiAnonymousClass || element instanceof PsiSyntheticClass) continue;
                return element;
            }
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return element instanceof PsiClass ? (PsiClass)element : null;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        TypeHierarchyBrowser typeHierarchyBrowser = new TypeHierarchyBrowser(target.getProject(), (PsiClass)target);
        if (typeHierarchyBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider", "createHierarchyBrowser"));
        }
        return typeHierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowser", "com/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider", "browserActivated"));
        }
        TypeHierarchyBrowser browser = (TypeHierarchyBrowser)hierarchyBrowser;
        String typeName = browser.isInterface() ? TypeHierarchyBrowserBase.SUBTYPES_HIERARCHY_TYPE : TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE;
        browser.changeView(typeName);
    }
}

