/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.config;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.config.PasswordSafeOptionsPanel;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PasswordSafeConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    final PasswordSafeSettings mySettings;
    private final PasswordSafe myPasswordSafe;
    PasswordSafeOptionsPanel myPanel;

    public PasswordSafeConfigurable(@NotNull PasswordSafeSettings settings, @NotNull PasswordSafe passwordSafe) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/passwordSafe/config/PasswordSafeConfigurable", "<init>"));
        }
        if (passwordSafe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passwordSafe", "com/intellij/ide/passwordSafe/config/PasswordSafeConfigurable", "<init>"));
        }
        this.mySettings = settings;
        this.myPasswordSafe = passwordSafe;
    }

    @Nls
    public String getDisplayName() {
        return "Passwords";
    }

    public String getHelpTopic() {
        return "reference.ide.settings.password.safe";
    }

    public JComponent createComponent() {
        this.myPanel = new PasswordSafeOptionsPanel(this.myPasswordSafe);
        this.myPanel.reset(this.mySettings);
        return this.myPanel.getRoot();
    }

    public boolean isModified() {
        return this.myPanel.isModified(this.mySettings);
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply(this.mySettings);
    }

    public void reset() {
        this.myPanel.reset(this.mySettings);
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    @NotNull
    public String getId() {
        if ("application.passwordSafe" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/config/PasswordSafeConfigurable", "getId"));
        }
        return "application.passwordSafe";
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

