/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.ui;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordSafePromptDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)PasswordSafePromptDialog.class.getName());
    private final PasswordPromptComponent myComponent;

    private PasswordSafePromptDialog(@Nullable Project project, @NotNull String title, @NotNull PasswordPromptComponent component) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/passwordSafe/ui/PasswordSafePromptDialog", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/passwordSafe/ui/PasswordSafePromptDialog", "<init>"));
        }
        super(project, true);
        this.setTitle(title);
        this.myComponent = component;
        this.setResizable(false);
        this.init();
    }

    public PasswordPromptComponent getComponent() {
        return this.myComponent;
    }

    protected JComponent createCenterPanel() {
        return this.myComponent.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myComponent.getPreferredFocusedComponent();
    }

    @Nullable
    public static String askPassword(Project project, String title, String message, @NotNull Class<?> requestor, String key, boolean resetPassword, String error) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/ui/PasswordSafePromptDialog", "askPassword"));
        }
        return PasswordSafePromptDialog.askPassword(project, title, message, requestor, key, resetPassword, error, null, null);
    }

    @Nullable
    public static String askPassword(String title, String message, @NotNull Class<?> requestor, String key, boolean resetPassword) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/ui/PasswordSafePromptDialog", "askPassword"));
        }
        return PasswordSafePromptDialog.askPassword(null, title, message, requestor, key, resetPassword, null);
    }

    @Nullable
    public static String askPassphrase(Project project, String title, String message, @NotNull Class<?> requestor, String key, boolean resetPassword, String error) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/ui/PasswordSafePromptDialog", "askPassphrase"));
        }
        return PasswordSafePromptDialog.askPassword(project, title, message, requestor, key, resetPassword, error, "Passphrase:", "Remember the passphrase");
    }

    @Nullable
    private static String askPassword(final Project project, final String title, final String message, final @NotNull Class<?> requestor, final String key, boolean resetPassword, final String error, final String promptLabel, final String checkboxLabel) {
        PasswordSafeImpl ps;
        block6: {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/ui/PasswordSafePromptDialog", "askPassword"));
            }
            ps = (PasswordSafeImpl)PasswordSafe.getInstance();
            try {
                if (resetPassword) {
                    ps.removePassword(project, requestor, key);
                } else {
                    String pw = ps.getPassword(project, requestor, key);
                    if (pw != null) {
                        return pw;
                    }
                }
            }
            catch (PasswordSafeException ex) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Failed to retrieve or reset password", (Throwable)ex);
            }
        }
        final Ref ref = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                block6: {
                    PasswordSafeSettings.ProviderType type = ps.getSettings().getProviderType();
                    PasswordPromptComponent component = new PasswordPromptComponent(type, message, false, promptLabel, checkboxLabel);
                    PasswordSafePromptDialog d = new PasswordSafePromptDialog(project, title, component);
                    d.setErrorText(error);
                    if (d.showAndGet()) {
                        ref.set((Object)new String(component.getPassword()));
                        try {
                            if (component.isRememberSelected()) {
                                ps.storePassword(project, requestor, key, (String)ref.get());
                            } else if (!type.equals((Object)PasswordSafeSettings.ProviderType.DO_NOT_STORE)) {
                                ps.getMemoryProvider().storePassword(project, requestor, key, (String)ref.get());
                            }
                        }
                        catch (PasswordSafeException e) {
                            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Failed to Store Password");
                            if (!LOG.isDebugEnabled()) break block6;
                            LOG.debug("Failed to store password", (Throwable)e);
                        }
                    }
                }
            }
        }, ModalityState.any());
        return (String)ref.get();
    }
}

