/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;

public class ModuleGroupUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "module_group";

    public ModuleGroupUrl(String url) {
        super(url, null, ELEMENT_TYPE);
    }

    @Override
    public Object[] createPath(Project project) {
        String[] groupPath = this.url.split(";");
        return new Object[]{new ModuleGroup(groupPath)};
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new ModuleGroupUrl(url);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element) {
        if (element instanceof ModuleGroup) {
            ModuleGroup group = (ModuleGroup)element;
            String[] groupPath = group.getGroupPath();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < groupPath.length; ++i) {
                String s = groupPath[i];
                sb.append(s);
                sb.append(";");
            }
            return new ModuleGroupUrl(sb.toString());
        }
        return null;
    }
}

