/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewCompositeModel
extends StructureViewModelBase
implements Disposable {
    private final StructureViewComposite.StructureViewDescriptor[] myViews;

    public StructureViewCompositeModel(PsiFile file, StructureViewComposite.StructureViewDescriptor[] views) {
        super(file, StructureViewCompositeModel.createRootNode(file, views));
        this.myViews = views;
    }

    private static StructureViewTreeElement createRootNode(final PsiFile file, final StructureViewComposite.StructureViewDescriptor[] views) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return file;
            }

            public void navigate(boolean requestFocus) {
                file.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                ItemPresentation itemPresentation = file.getPresentation();
                if (itemPresentation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$1", "getPresentation"));
                }
                return itemPresentation;
            }

            @NotNull
            public TreeElement[] getChildren() {
                ArrayList<TreeElement> elements = new ArrayList<TreeElement>();
                for (StructureViewComposite.StructureViewDescriptor view : views) {
                    elements.add(StructureViewCompositeModel.createTreeElementFromView(file, view));
                }
                TreeElement[] treeElementArray = elements.toArray(new TreeElement[elements.size()]);
                if (treeElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$1", "getChildren"));
                }
                return treeElementArray;
            }
        };
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        HashSet<NodeProvider> providers = new HashSet<NodeProvider>();
        for (StructureViewComposite.StructureViewDescriptor view : this.myViews) {
            StructureViewModel model = view.structureView.getTreeModel();
            if (!(model instanceof ProvidingTreeModel)) continue;
            providers.addAll(((ProvidingTreeModel)model).getNodeProviders());
        }
        HashSet<NodeProvider> hashSet = providers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel", "getNodeProviders"));
        }
        return hashSet;
    }

    @NotNull
    public Filter[] getFilters() {
        HashSet<Filter> filters = new HashSet<Filter>();
        for (StructureViewComposite.StructureViewDescriptor view : this.myViews) {
            StructureViewModel model = view.structureView.getTreeModel();
            filters.addAll(Arrays.asList(model.getFilters()));
        }
        Filter[] filterArray = filters.toArray(new Filter[filters.size()]);
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel", "getFilters"));
        }
        return filterArray;
    }

    private static TreeElement createTreeElementFromView(final PsiFile file, final StructureViewComposite.StructureViewDescriptor view) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return view;
            }

            public void navigate(boolean requestFocus) {
                file.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                ItemPresentation itemPresentation = new ItemPresentation(){

                    @Nullable
                    public String getPresentableText() {
                        return view.title;
                    }

                    @Nullable
                    public String getLocationString() {
                        return null;
                    }

                    @Nullable
                    public Icon getIcon(boolean unused) {
                        return view.icon;
                    }
                };
                if (itemPresentation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$2", "getPresentation"));
                }
                return itemPresentation;
            }

            @NotNull
            public TreeElement[] getChildren() {
                TreeElement[] treeElementArray = view.structureView.getTreeModel().getRoot().getChildren();
                if (treeElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/StructureViewCompositeModel$2", "getChildren"));
                }
                return treeElementArray;
            }
        };
    }
}

