/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class ProjectWizardUtil {
    private ProjectWizardUtil() {
    }

    public static String findNonExistingFileName(String searchDirectory, @NonNls String preferredName, String extension) {
        int idx = 0;
        while (true) {
            String fileName = (idx > 0 ? preferredName + idx : preferredName) + extension;
            if (!new File(searchDirectory + File.separator + fileName).exists()) {
                return fileName;
            }
            ++idx;
        }
    }

    public static boolean createDirectoryIfNotExists(String promptPrefix, String directoryPath, boolean promptUser) {
        File dir = new File(directoryPath);
        if (!dir.exists()) {
            int answer;
            if (promptUser && (answer = Messages.showOkCancelDialog((String)IdeBundle.message((String)"promot.projectwizard.directory.does.not.exist", (Object[])new Object[]{promptPrefix, dir.getPath(), ApplicationNamesInfo.getInstance().getFullProductName()}), (String)IdeBundle.message((String)"title.directory.does.not.exist", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                return false;
            }
            try {
                VfsUtil.createDirectories((String)dir.getPath());
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.failed.to.create.directory", (Object[])new Object[]{dir.getPath()}), (String)CommonBundle.getErrorTitle());
                return false;
            }
        }
        return true;
    }
}

