/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.navigation;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class JsonQualifiedNameProvider
implements QualifiedNameProvider {
    @Override
    @Nullable
    public PsiElement adjustElementToCopy(PsiElement element) {
        return element;
    }

    @Override
    @Nullable
    public String getQualifiedName(PsiElement element) {
        if (!(element instanceof JsonElement)) {
            return null;
        }
        LinkedList<String> qualifiers = new LinkedList<String>();
        JsonProperty parentProperty = (JsonProperty)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JsonProperty.class});
        while (parentProperty != null) {
            qualifiers.addFirst(parentProperty.getName());
            parentProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)parentProperty, JsonProperty.class);
        }
        return qualifiers.isEmpty() ? null : StringUtil.join(qualifiers, (String)".");
    }

    @Override
    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        return null;
    }

    @Override
    public void insertQualifiedName(String fqn, PsiElement element, Editor editor, Project project) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)fqn);
    }
}

