/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyAdapter;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class XmlWhiteSpaceFormattingStrategy
extends WhiteSpaceFormattingStrategyAdapter {
    private static void addWhitespaceToTagBody(ASTNode treePrev, LeafElement whiteSpaceElement) {
        boolean before;
        XmlText xmlText;
        CharTable charTable = SharedImplUtil.findCharTableByTree(treePrev);
        ASTNode treeParent = treePrev.getTreeParent();
        if (treePrev.getElementType() == XmlElementType.XML_TEXT) {
            xmlText = (XmlText)treePrev.getPsi();
            before = true;
        } else if (treePrev.getTreePrev().getElementType() == XmlElementType.XML_TEXT) {
            xmlText = (XmlText)treePrev.getTreePrev().getPsi();
            before = false;
        } else {
            xmlText = (XmlText)Factory.createCompositeElement(XmlElementType.XML_TEXT, charTable, treeParent.getPsi().getManager());
            CodeEditUtil.setNodeGenerated(xmlText.getNode(), true);
            treeParent.addChild(xmlText.getNode(), treePrev);
            before = true;
        }
        ASTNode node = xmlText.getNode();
        assert (node != null);
        TreeElement anchorInText = (TreeElement)(before ? node.getFirstChildNode() : node.getLastChildNode());
        if (anchorInText == null) {
            node.addChild((ASTNode)whiteSpaceElement);
        } else if (anchorInText.getElementType() != XmlTokenType.XML_WHITE_SPACE) {
            node.addChild((ASTNode)whiteSpaceElement, (ASTNode)(before ? anchorInText : null));
        } else {
            String text = before ? whiteSpaceElement.getText() + anchorInText.getText() : anchorInText.getText() + whiteSpaceElement.getText();
            node.replaceChild((ASTNode)anchorInText, (ASTNode)ASTFactory.whitespace(text));
        }
    }

    protected boolean isInsideTagBody(@NotNull ASTNode place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/xml/XmlWhiteSpaceFormattingStrategy", "isInsideTagBody"));
        }
        ASTNode treeParent = place.getTreeParent();
        if (treeParent.getElementType() != XmlElementType.XML_TAG && treeParent.getElementType() != XmlElementType.HTML_TAG) {
            return false;
        }
        while (place != null) {
            if (place.getElementType() == XmlTokenType.XML_TAG_END) {
                return true;
            }
            place = place.getTreePrev();
        }
        return false;
    }

    @Override
    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        if (treePrev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treePrev", "com/intellij/lang/xml/XmlWhiteSpaceFormattingStrategy", "addWhitespace"));
        }
        if (whiteSpaceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceElement", "com/intellij/lang/xml/XmlWhiteSpaceFormattingStrategy", "addWhitespace"));
        }
        if (this.isInsideTagBody(treePrev)) {
            XmlWhiteSpaceFormattingStrategy.addWhitespaceToTagBody(treePrev, whiteSpaceElement);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/xml/XmlWhiteSpaceFormattingStrategy", "containsWhitespacesOnly"));
        }
        return node.getElementType() == XmlTokenType.XML_DATA_CHARACTERS && node.getText().trim().length() == 0;
    }
}

