/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import java.util.TreeMap;

public class FragmentSeparatorsPositionConsumer {
    private final TreeMap<Integer, TornSeparator> myLeft = new TreeMap();
    private final TreeMap<Integer, TornSeparator> myRight = new TreeMap();

    public void prepare(int left, int right) {
        TornSeparator tornSeparator = new TornSeparator(left, right);
        this.myLeft.put(left, tornSeparator);
        this.myRight.put(right, tornSeparator);
    }

    public void addLeft(int line, int offset) {
        this.myLeft.get(line).setLeftOffset(offset);
    }

    public void addRight(int line, int offset) {
        this.myRight.get(line).setRightOffset(offset);
    }

    public TreeMap<Integer, TornSeparator> getLeft() {
        return this.myLeft;
    }

    public TreeMap<Integer, TornSeparator> getRight() {
        return this.myRight;
    }

    public void clear() {
        this.myLeft.clear();
        this.myRight.clear();
    }

    public static class TornSeparator {
        private final int myLeftLine;
        private final int myRightLine;
        private int myLeftOffset;
        private int myRightOffset;

        public TornSeparator(int leftLine, int rightLine) {
            this.myLeftLine = leftLine;
            this.myRightLine = rightLine;
        }

        public int getLeftOffset() {
            return this.myLeftOffset;
        }

        public void setLeftOffset(int leftOffset) {
            this.myLeftOffset = leftOffset;
        }

        public int getRightOffset() {
            return this.myRightOffset;
        }

        public void setRightOffset(int rightOffset) {
            this.myRightOffset = rightOffset;
        }

        public int getLeftLine() {
            return this.myLeftLine;
        }

        public int getRightLine() {
            return this.myRightLine;
        }
    }
}

