/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class ColorProvider {
    public abstract Color getColor();

    public static ColorProvider byColor(Color color) {
        return new StaticColorHolder(color);
    }

    public static ColorProvider byColorScheme(Editor editor, ColorKey ... keys) {
        return ColorProvider.byColorsScheme(editor.getColorsScheme(), keys);
    }

    public static ColorProvider byColorsScheme(EditorColorsScheme scheme, ColorKey ... keys) {
        return new ColorSchemeBasedHolder(scheme, keys);
    }

    private static class ColorSchemeBasedHolder
    extends ColorProvider {
        private final EditorColorsScheme myScheme;
        private final List<ColorKey> myKeys = new ArrayList<ColorKey>();

        ColorSchemeBasedHolder(EditorColorsScheme scheme, ColorKey ... keys) {
            this.myScheme = scheme;
            this.myKeys.addAll(Arrays.asList(keys));
            Collections.reverse(this.myKeys);
        }

        @Override
        public Color getColor() {
            while (!this.myKeys.isEmpty()) {
                ColorKey key = this.myKeys.get(this.myKeys.size() - 1);
                Color result2 = this.myScheme.getColor(key);
                if (result2 == null || result2.equals(this.myScheme.getDefaultForeground())) {
                    this.myKeys.remove(this.myKeys.size() - 1);
                    continue;
                }
                return result2;
            }
            return this.myScheme.getDefaultForeground();
        }
    }

    private static class StaticColorHolder
    extends ColorProvider {
        private final Color myColor;

        StaticColorHolder(Color color) {
            this.myColor = color;
        }

        @Override
        public Color getColor() {
            return this.myColor;
        }
    }
}

