/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.model;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRegistry<T> {
    @NotNull
    private final TIntObjectHashMap<T> myDataById = new TIntObjectHashMap();
    private transient TObjectIntHashMap<T> myIdsByData = new TObjectIntHashMap();

    @NotNull
    public T dataById(int id) throws IllegalArgumentException {
        Object result2 = this.myDataById.get(id);
        if (result2 == null) {
            throw new IllegalArgumentException("No data is registered for id " + id);
        }
        Object object = result2;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/model/AbstractRegistry", "dataById"));
        }
        return (T)object;
    }

    public int getId(@NotNull T data) throws IllegalStateException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/richcopy/model/AbstractRegistry", "getId"));
        }
        if (this.myIdsByData == null) {
            throw new IllegalStateException(String.format("Can't register data '%s'. Reason: the %s registry is already sealed", data, this.getClass().getName()));
        }
        int id = this.myIdsByData.get(data);
        if (id <= 0) {
            id = this.myIdsByData.size() + 1;
            this.myDataById.put(id, data);
            this.myIdsByData.put(data, id);
        }
        return id;
    }

    public int[] getAllIds() {
        int[] result2 = this.myDataById.keys();
        Arrays.sort(result2);
        return result2;
    }

    public int size() {
        return this.myDataById.size();
    }

    public void seal() {
        this.myIdsByData = null;
        this.myDataById.compact();
    }
}

