/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ShowExternalSystemSettingsAction
extends ExternalSystemAction {
    public ShowExternalSystemSettingsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.open.settings.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.open.settings.description", (Object[])new Object[]{"external"}));
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        ProjectSystemId systemId = this.getSystemId(e);
        if (systemId == null) {
            return false;
        }
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.open.settings.text", (Object[])new Object[]{systemId.getReadableName()}));
        e.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.open.settings.description", (Object[])new Object[]{systemId.getReadableName()}));
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        ProjectSystemId systemId = this.getSystemId(e);
        if (systemId != null) {
            ShowExternalSystemSettingsAction.showSettingsFor(this.getProject(e), systemId);
        }
    }

    protected static void showSettingsFor(Project project, @NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/action/ShowExternalSystemSettingsAction", "showSettingsFor"));
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project, systemId.getReadableName());
    }
}

