/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.BeforeRunTask;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemBeforeRunTask
extends BeforeRunTask<ExternalSystemBeforeRunTask> {
    @NotNull
    private final ExternalSystemTaskExecutionSettings myTaskExecutionSettings;

    public ExternalSystemBeforeRunTask(@NotNull Key<ExternalSystemBeforeRunTask> providerId, @NotNull ProjectSystemId systemId) {
        if (providerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerId", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTask", "<init>"));
        }
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTask", "<init>"));
        }
        super(providerId);
        this.myTaskExecutionSettings = new ExternalSystemTaskExecutionSettings();
        this.myTaskExecutionSettings.setExternalSystemIdString(systemId.getId());
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getTaskExecutionSettings() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.myTaskExecutionSettings;
        if (externalSystemTaskExecutionSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTask", "getTaskExecutionSettings"));
        }
        return externalSystemTaskExecutionSettings;
    }

    public void writeExternal(Element element) {
        super.writeExternal(element);
        element.setAttribute("tasks", StringUtil.join((Collection)this.myTaskExecutionSettings.getTaskNames(), (String)" "));
        if (this.myTaskExecutionSettings.getExternalProjectPath() != null) {
            element.setAttribute("externalProjectPath", this.myTaskExecutionSettings.getExternalProjectPath());
        }
        if (this.myTaskExecutionSettings.getVmOptions() != null) {
            element.setAttribute("vmOptions", this.myTaskExecutionSettings.getVmOptions());
        }
        if (this.myTaskExecutionSettings.getScriptParameters() != null) {
            element.setAttribute("scriptParameters", this.myTaskExecutionSettings.getScriptParameters());
        }
    }

    public void readExternal(Element element) {
        super.readExternal(element);
        this.myTaskExecutionSettings.setTaskNames(StringUtil.split((String)StringUtil.notNullize((String)element.getAttributeValue("tasks")), (String)" "));
        this.myTaskExecutionSettings.setExternalProjectPath(element.getAttributeValue("externalProjectPath"));
        this.myTaskExecutionSettings.setVmOptions(element.getAttributeValue("vmOptions"));
        this.myTaskExecutionSettings.setScriptParameters(element.getAttributeValue("scriptParameters"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalSystemBeforeRunTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalSystemBeforeRunTask task = (ExternalSystemBeforeRunTask)((Object)o);
        return this.myTaskExecutionSettings.equals((Object)task.myTaskExecutionSettings);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myTaskExecutionSettings.hashCode();
        return result2;
    }
}

