/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import org.jetbrains.annotations.NotNull;

public class IdeUIModifiableModelsProvider
extends AbstractIdeModifiableModelsProvider {
    private final ModifiableModuleModel myModel;
    private final ModulesConfigurator myModulesConfigurator;
    private final ModifiableArtifactModel myModifiableArtifactModel;
    private final LibrariesModifiableModel myLibrariesModel;

    public IdeUIModifiableModelsProvider(Project project, ModifiableModuleModel model, ModulesConfigurator modulesConfigurator, ModifiableArtifactModel modifiableArtifactModel) {
        super(project);
        this.myModel = model;
        this.myModulesConfigurator = modulesConfigurator;
        this.myModifiableArtifactModel = modifiableArtifactModel;
        ProjectLibrariesConfigurable configurable = ProjectLibrariesConfigurable.getInstance(project);
        this.myLibrariesModel = configurable.getModelProvider().getModifiableModel();
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableProjectLibrariesModel() {
        LibrariesModifiableModel librariesModifiableModel = this.myLibrariesModel;
        if (librariesModifiableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeUIModifiableModelsProvider", "getModifiableProjectLibrariesModel"));
        }
        return librariesModifiableModel;
    }

    @Override
    protected ModifiableArtifactModel doGetModifiableArtifactModel() {
        return this.myModifiableArtifactModel;
    }

    @Override
    protected ModifiableModuleModel doGetModifiableModuleModel() {
        return this.myModel;
    }

    @Override
    protected ModifiableRootModel doGetModifiableRootModel(Module module) {
        return this.myModulesConfigurator.getOrCreateModuleEditor(module).getModifiableRootModel();
    }

    @Override
    protected ModifiableFacetModel doGetModifiableFacetModel(Module module) {
        return (ModifiableFacetModel)this.myModulesConfigurator.getFacetModel(module);
    }

    @Override
    protected Library.ModifiableModel doGetModifiableLibraryModel(Library library) {
        return this.myLibrariesModel.getLibraryModifiableModel(library);
    }

    @Override
    public void commit() {
        this.processExternalArtifactDependencies();
    }

    @Override
    public void dispose() {
    }

    @Override
    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.defaultModalityState();
    }
}

