/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EnforcedPlainTextFileTypeFactory
extends FileTypeFactory {
    public static final LayeredIcon ENFORCED_PLAIN_TEXT_ICON = new LayeredIcon(2);
    public static final String ENFORCED_PLAIN_TEXT = "Enforced Plain Text";
    private final FileTypeIdentifiableByVirtualFile myFileType = new FileTypeIdentifiableByVirtualFile(){

        @Override
        public boolean isMyFileType(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeFactory$1", "isMyFileType"));
            }
            return EnforcedPlainTextFileTypeFactory.isMarkedAsPlainText(file);
        }

        @NotNull
        public String getName() {
            if (EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeFactory$1", "getName"));
            }
            return EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT;
        }

        @NotNull
        public String getDescription() {
            if (EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeFactory$1", "getDescription"));
            }
            return EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT;
        }

        @NotNull
        public String getDefaultExtension() {
            if ("fakeTxt" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeFactory$1", "getDefaultExtension"));
            }
            return "fakeTxt";
        }

        public Icon getIcon() {
            return ENFORCED_PLAIN_TEXT_ICON;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeFactory$1", "getCharset"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeFactory$1", "getCharset"));
            }
            return null;
        }
    };

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeFactory", "createFileTypes"));
        }
        consumer.consume((FileType)this.myFileType, "");
    }

    private static boolean isMarkedAsPlainText(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeFactory", "isMarkedAsPlainText"));
        }
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        return typeManager != null && typeManager.isMarkedAsPlainText(file);
    }

    static {
        ENFORCED_PLAIN_TEXT_ICON.setIcon(AllIcons.FileTypes.Text, 0);
        ENFORCED_PLAIN_TEXT_ICON.setIcon(PlatformIcons.EXCLUDED_FROM_COMPILE_ICON, 1);
    }
}

