/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.newEditor.OptionsEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSettingsDialog
extends DialogWrapper
implements DataProvider {
    private Project myProject;
    private ConfigurableGroup[] myGroups;
    private Configurable myPreselected;
    private OptionsEditor myEditor;
    private ApplyAction myApplyAction;
    public static final String DIMENSION_KEY = "OptionsEditor";
    @NonNls
    static final String LAST_SELECTED_CONFIGURABLE = "options.lastSelected";

    public IdeSettingsDialog(Project project, ConfigurableGroup[] groups, @Nullable Configurable preselectedConfigurable, boolean applicationModalIfPossible) {
        super(project, true, applicationModalIfPossible);
        this.init(project, groups, preselectedConfigurable != null ? preselectedConfigurable : IdeSettingsDialog.findLastSavedConfigurable(groups, project));
    }

    public IdeSettingsDialog(Project project, ConfigurableGroup[] groups, @NotNull String preselectedConfigurableDisplayName, boolean applicationModalIfPossible) {
        if (preselectedConfigurableDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedConfigurableDisplayName", "com/intellij/openapi/options/newEditor/IdeSettingsDialog", "<init>"));
        }
        super(project, true, applicationModalIfPossible);
        this.init(project, groups, IdeSettingsDialog.getPreselectedByDisplayName(groups, preselectedConfigurableDisplayName, project));
    }

    public IdeSettingsDialog(Project project, ConfigurableGroup[] groups, @Nullable Configurable preselectedConfigurable) {
        super(project, true);
        this.init(project, groups, preselectedConfigurable != null ? preselectedConfigurable : IdeSettingsDialog.findLastSavedConfigurable(groups, project));
    }

    public IdeSettingsDialog(Project project, ConfigurableGroup[] groups, @NotNull String preselectedConfigurableDisplayName) {
        if (preselectedConfigurableDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedConfigurableDisplayName", "com/intellij/openapi/options/newEditor/IdeSettingsDialog", "<init>"));
        }
        super(project, true);
        this.init(project, groups, IdeSettingsDialog.getPreselectedByDisplayName(groups, preselectedConfigurableDisplayName, project));
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return IdeBorderFactory.createEmptyBorder((int)0);
    }

    private void init(Project project, ConfigurableGroup[] groups, @Nullable Configurable preselected) {
        this.myProject = project;
        this.myGroups = groups;
        this.myPreselected = preselected;
        this.setTitle(CommonBundle.settingsTitle());
        this.init();
    }

    @Nullable
    private static Configurable getPreselectedByDisplayName(ConfigurableGroup[] groups, String preselectedConfigurableDisplayName, Project project) {
        Configurable result2 = new ConfigurableVisitor.ByName(preselectedConfigurableDisplayName).find(groups);
        return result2 == null ? IdeSettingsDialog.findLastSavedConfigurable(groups, project) : result2;
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent panel = super.createSouthPanel();
        CustomLineBorder line = new CustomLineBorder((Color)new JBColor(Gray._153.withAlpha(128), Gray._100.withAlpha(128)), 1, 0, 0, 0);
        panel.setBorder(new CompoundBorder((Border)line, new EmptyBorder(8, 12, 8, 12)));
        return panel;
    }

    protected JComponent createCenterPanel() {
        this.myEditor = new OptionsEditor(this.myProject, this.myGroups, this.myPreselected);
        this.myEditor.getContext().addColleague(new OptionsEditorColleague.Adapter(){

            @Override
            public ActionCallback onModifiedAdded(Configurable configurable) {
                IdeSettingsDialog.this.updateStatus();
                return ActionCallback.DONE;
            }

            @Override
            public ActionCallback onModifiedRemoved(Configurable configurable) {
                IdeSettingsDialog.this.updateStatus();
                return ActionCallback.DONE;
            }

            @Override
            public ActionCallback onErrorsChanged() {
                IdeSettingsDialog.this.updateStatus();
                return ActionCallback.DONE;
            }
        });
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myEditor);
        return this.myEditor;
    }

    public boolean updateStatus() {
        this.myApplyAction.setEnabled(this.myEditor.canApply());
        Map<Configurable, ConfigurationException> errors = this.myEditor.getContext().getErrors();
        if (errors.size() == 0) {
            this.setErrorText(null);
        } else {
            String text = "Changes were not applied because of an error";
            String errorMessage = IdeSettingsDialog.getErrorMessage(errors);
            if (errorMessage != null) {
                text = text + "<br>" + errorMessage;
            }
            this.setErrorText(text);
        }
        return errors.size() == 0;
    }

    @Nullable
    private static String getErrorMessage(Map<Configurable, ConfigurationException> errors) {
        Collection<ConfigurationException> values = errors.values();
        ConfigurationException[] exceptions = values.toArray(new ConfigurationException[values.size()]);
        if (exceptions.length > 0) {
            return exceptions[0].getMessage();
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    public void doOKAction() {
        this.myEditor.flushModifications();
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (IdeSettingsDialog.this.myEditor.canApply()) {
                    IdeSettingsDialog.this.myEditor.apply();
                    if (!IdeSettingsDialog.this.updateStatus()) {
                        return;
                    }
                }
                IdeSettingsDialog.this.saveCurrentConfigurable();
                ApplicationManager.getApplication().saveAll();
                IdeSettingsDialog.super.doOKAction();
            }
        });
    }

    private void saveCurrentConfigurable() {
        Configurable current = this.myEditor.getContext().getCurrentConfigurable();
        if (current == null) {
            return;
        }
        PropertiesComponent props = PropertiesComponent.getInstance((Project)this.myProject);
        if (current instanceof SearchableConfigurable) {
            props.setValue(LAST_SELECTED_CONFIGURABLE, ((SearchableConfigurable)current).getId());
        } else {
            props.setValue(LAST_SELECTED_CONFIGURABLE, current.getClass().getName());
        }
    }

    @Nullable
    private static Configurable findLastSavedConfigurable(ConfigurableGroup[] groups, Project project) {
        String id = PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_CONFIGURABLE);
        if (id == null) {
            return null;
        }
        return new ConfigurableVisitor.ByID(id).find(groups);
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && this.myEditor.getContext().isHoldingFilter()) {
            this.myEditor.clearFilter();
            return;
        }
        super.doCancelAction(source);
    }

    public void doCancelAction() {
        this.saveCurrentConfigurable();
        super.doCancelAction();
    }

    @NotNull
    protected Action[] createActions() {
        this.myApplyAction = new ApplyAction();
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.myApplyAction, this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/IdeSettingsDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        String topic = this.myEditor.getHelpTopic();
        if (topic != null) {
            HelpManager.getInstance().invokeHelp(topic);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public Object getData(@NonNls String dataId) {
        if (OptionsEditor.KEY.is(dataId)) {
            return this.myEditor;
        }
        return this.myEditor == null ? null : this.myEditor.getData(dataId);
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            super(CommonBundle.getApplyButtonText());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                @Override
                public void run() {
                    IdeSettingsDialog.this.myEditor.apply();
                }
            });
            IdeSettingsDialog.this.myEditor.revalidate();
            IdeSettingsDialog.this.myEditor.repaint();
            IdeSettingsDialog.this.updateStatus();
        }
    }
}

